/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginInfoImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.login.LoginStore;
import com.atlassian.jira.util.RealClock;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LoginStoreImpl
implements LoginStore {
    private static final Logger log = Logger.getLogger(LoginStoreImpl.class);
    private static final String LAST_LOGIN_TIME = "login.lastLoginMillis";
    private static final String PREV_LOGIN_TIME = "login.previousLoginMillis";
    private static final String LAST_FAILED_TIME = "login.lastFailedLoginMillis";
    private static final String LOGIN_COUNT = "login.count";
    private static final String CURRENT_FAILED_COUNT = "login.currentFailedCount";
    private static final String TOTAL_FAILED_COUNT = "login.totalFailedCount";
    private final Clock clock;
    private final ApplicationProperties applicationProperties;
    private final CrowdService crowdService;

    public LoginStoreImpl(ApplicationProperties applicationProperties) {
        this(RealClock.getInstance(), applicationProperties, ComponentManager.getComponentInstanceOfType(CrowdService.class));
    }

    LoginStoreImpl(Clock clock, ApplicationProperties applicationProperties, CrowdService crowdService) {
        this.clock = Assertions.notNull("clock", clock);
        this.applicationProperties = Assertions.notNull("applicationProperties", applicationProperties);
        this.crowdService = crowdService;
    }

    @Override
    public LoginInfo recordLoginAttempt(User user, boolean authenticated) {
        Assertions.notNull("user", user);
        UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getName());
        if (authenticated) {
            this.setLong(user, CURRENT_FAILED_COUNT, 0L);
            Long lastLoginTime = this.getLong(userWithAttributes, LAST_LOGIN_TIME);
            this.setLong(user, LAST_LOGIN_TIME, this.now());
            if (lastLoginTime != null) {
                this.setLong(user, PREV_LOGIN_TIME, lastLoginTime);
            }
            this.incrementLong(userWithAttributes, LOGIN_COUNT, 1);
        } else {
            this.setLong(user, LAST_FAILED_TIME, this.now());
            this.incrementLong(userWithAttributes, CURRENT_FAILED_COUNT, 1);
            this.incrementLong(userWithAttributes, TOTAL_FAILED_COUNT, 1);
        }
        return this.getLoginInfo(user);
    }

    @Override
    public long getMaxAuthenticationAttemptsAllowed() {
        String maxStr = this.applicationProperties.getDefaultBackedString("jira.maximum.authentication.attempts.allowed");
        try {
            return StringUtils.isBlank((String)maxStr) ? Long.MAX_VALUE : Long.parseLong(maxStr);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Unable to read the MaxAuthenticationAttemptsAllowed value ' " + maxStr + "'.  Defaulting to UNLIMITED.  If you really care avbout security you will want to find out why this value cant be read."));
            return Long.MAX_VALUE;
        }
    }

    @Override
    public void resetFailedLoginCount(User user) {
        this.setLong(user, CURRENT_FAILED_COUNT, 0L);
    }

    @Override
    public LoginInfo getLoginInfo(User user) {
        Assertions.notNull("user", user);
        UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getName());
        return this.getLoginInfoInternal(userWithAttributes);
    }

    private LoginInfo getLoginInfoInternal(UserWithAttributes userWithAttributes) {
        Long lastLoginTime = this.getLong(userWithAttributes, LAST_LOGIN_TIME);
        Long previousLoginTime = this.getLong(userWithAttributes, PREV_LOGIN_TIME);
        Long lastFailedTime = this.getLong(userWithAttributes, LAST_FAILED_TIME);
        Long loginCount = this.getLong(userWithAttributes, LOGIN_COUNT);
        Long currentFailedCount = this.getLong(userWithAttributes, CURRENT_FAILED_COUNT);
        Long totalFailedCount = this.getLong(userWithAttributes, TOTAL_FAILED_COUNT);
        boolean elevatedSecurityCheckRequired = false;
        long maxAuthenticationAttemptsAllowed = this.getMaxAuthenticationAttemptsAllowed();
        return new LoginInfoImpl(lastLoginTime, previousLoginTime, lastFailedTime, loginCount, currentFailedCount, totalFailedCount, maxAuthenticationAttemptsAllowed, false);
    }

    private void setLong(User user, String key, long value) {
        try {
            this.crowdService.setUserAttribute(user, key, Long.valueOf(value).toString());
        }
        catch (OperationNotPermittedException e) {
            log.error((Object)e);
        }
    }

    private Long getLong(UserWithAttributes userWithAttributes, String key) {
        String attribute = userWithAttributes.getValue(key);
        if (attribute != null) {
            return Long.valueOf(attribute);
        }
        return null;
    }

    private void incrementLong(UserWithAttributes userWithAttributes, String key, int defaultValue) {
        Long currentValue = this.getLong(userWithAttributes, key);
        this.setLong((User)userWithAttributes, key, currentValue == null ? (long)defaultValue : currentValue + 1L);
    }

    private long now() {
        return this.clock.getCurrentDate().getTime();
    }
}

