/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.jira.bc.security.login.CaptchaChallengeRequired;
import com.atlassian.jira.bc.security.login.DeniedReason;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginInfoImpl;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.bc.security.login.LoginReason;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.bc.security.login.LoginResultImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.security.login.LoginStore;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.google.common.collect.Sets;
import com.octo.captcha.service.CaptchaServiceException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;
import webwork.action.factory.SessionMap;

public class LoginManagerImpl
implements LoginManager {
    private static final Logger log = Logger.getLogger(LoginManagerImpl.class);
    private static final Logger loggerSecurityEvents = LoginLoggers.LOGIN_SECURITY_EVENTS;
    private static final String AUTHORISED_FAILURE = "com.atlassian.jira.security.login.LoginManager.AUTHORISED_FAILURE";
    private static final String ELEVATED_SECURITY_FAILURE = "com.atlassian.jira.security.login.LoginManager.ELEVATED_SECURITY_FAILURE";
    private static final String OS_CAPTCHA = "os_captcha";
    private final PermissionManager permissionManager;
    private final LoginStore loginStore;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CrowdService crowdService;
    private final StaticDependencies staticDependencies;
    private final JiraCaptchaService jiraCaptchaService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public LoginManagerImpl(PermissionManager permissionManager, LoginStore loginStore, JiraAuthenticationContext jiraAuthenticationContext, CrowdService crowdService, JiraCaptchaService jiraCaptchaService, VelocityRequestContextFactory velocityRequestContextFactory) {
        this(permissionManager, loginStore, jiraAuthenticationContext, crowdService, jiraCaptchaService, new InternalStaticDependencies(crowdService), velocityRequestContextFactory);
    }

    public LoginManagerImpl(PermissionManager permissionManager, LoginStore loginStore, JiraAuthenticationContext jiraAuthenticationContext, CrowdService crowdService, JiraCaptchaService jiraCaptchaService, StaticDependencies staticDependencies, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.loginStore = Assertions.notNull("loginStore", loginStore);
        this.jiraAuthenticationContext = Assertions.notNull("jiraAuthenticationContext", jiraAuthenticationContext);
        this.crowdService = Assertions.notNull("crowdService", crowdService);
        this.jiraCaptchaService = Assertions.notNull("jiraCaptchaService", jiraCaptchaService);
        this.staticDependencies = Assertions.notNull("staticDependencies", staticDependencies);
        this.velocityRequestContextFactory = Assertions.notNull("velocityRequestContextFactory", velocityRequestContextFactory);
    }

    @Override
    public LoginInfo getLoginInfo(String userName) {
        User user = this.crowdService.getUser(userName);
        if (user == null) {
            return null;
        }
        LoginInfo storedLoginInfo = this.loginStore.getLoginInfo(user);
        return this.tweakLoginInfo(storedLoginInfo);
    }

    @Override
    public boolean performElevatedSecurityCheck(HttpServletRequest httpServletRequest, String userName) {
        boolean captchOK;
        Boolean isResponseCorrect;
        httpServletRequest.removeAttribute(ELEVATED_SECURITY_FAILURE);
        LoginInfo loginInfo = this.getLoginInfo(userName);
        if (loginInfo == null) {
            return true;
        }
        if (!loginInfo.isElevatedSecurityCheckRequired()) {
            return true;
        }
        String captcha = httpServletRequest.getParameter(OS_CAPTCHA);
        String sessionId = httpServletRequest.getSession(true).getId();
        try {
            isResponseCorrect = this.jiraCaptchaService.getImageCaptchaService().validateResponseForID(sessionId, (Object)captcha);
        }
        catch (CaptchaServiceException e) {
            isResponseCorrect = false;
        }
        boolean bl = captchOK = isResponseCorrect == null || isResponseCorrect != false;
        if (!captchOK) {
            httpServletRequest.setAttribute(ELEVATED_SECURITY_FAILURE, (Object)true);
        }
        return captchOK;
    }

    @Override
    public boolean authorise(User user, HttpServletRequest httpServletRequest) {
        boolean authorised;
        Assertions.notNull("user", user);
        httpServletRequest.removeAttribute(AUTHORISED_FAILURE);
        boolean bl = authorised = this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(1, user);
        if (!authorised) {
            httpServletRequest.setAttribute(AUTHORISED_FAILURE, (Object)true);
        }
        return authorised;
    }

    @Override
    public LoginResult authenticate(User user, String password) {
        Assertions.notNull("user", user);
        String userName = user.getName();
        LoginInfo loginInfo = this.getLoginInfo(userName);
        LoginReason reason = loginInfo.isElevatedSecurityCheckRequired() ? LoginReason.AUTHENTICATION_DENIED : (this.staticDependencies.authenticate(user, password) ? LoginReason.OK : LoginReason.AUTHENTICATED_FAILED);
        loginInfo = this.tweakLoginInfo(this.recordLoginAttempt(user, reason == LoginReason.OK));
        this.logSecurityEvents(userName, loginInfo, reason);
        return new LoginResultImpl(reason, loginInfo, user.getName());
    }

    @Override
    public LoginResult authenticateWithoutElevatedCheck(User user, String password) {
        Assertions.notNull("user", user);
        String userName = user.getName();
        LoginReason reason = this.staticDependencies.authenticate(user, password) ? LoginReason.OK : LoginReason.AUTHENTICATED_FAILED;
        LoginInfo loginInfo = this.tweakLoginInfo(this.recordLoginAttempt(user, reason == LoginReason.OK));
        this.logSecurityEvents(userName, loginInfo, reason);
        return new LoginResultImpl(reason, loginInfo, user.getName());
    }

    @Override
    public LoginInfo onLoginAttempt(HttpServletRequest httpServletRequest, String userName, boolean loginSuccessful) {
        LoginReason reason;
        User user = this.crowdService.getUser(userName);
        if (user == null) {
            return null;
        }
        LoginInfo loginInfo = this.tweakLoginInfo(this.recordLoginAttempt(user, loginSuccessful));
        LoginReason loginReason = reason = loginSuccessful ? LoginReason.OK : LoginReason.AUTHENTICATED_FAILED;
        if (!loginSuccessful) {
            if (httpServletRequest.getAttribute(ELEVATED_SECURITY_FAILURE) != null) {
                reason = LoginReason.AUTHENTICATION_DENIED;
            } else if (httpServletRequest.getAttribute(AUTHORISED_FAILURE) != null) {
                reason = LoginReason.AUTHORISATION_FAILED;
            }
        }
        this.recordLoginResultInRequest(httpServletRequest, new LoginResultImpl(reason, loginInfo, userName, this.getLoginDeniedReasons(httpServletRequest)));
        this.logSecurityEvents(userName, loginInfo, reason);
        return loginInfo;
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        Assertions.notNull("request", request);
        Assertions.notNull("response", response);
        String userName = this.jiraAuthenticationContext.getLoggedInUser() == null ? "unknown" : this.jiraAuthenticationContext.getLoggedInUser().getName();
        HttpSession currentSession = request.getSession(false);
        if (currentSession != null) {
            currentSession.invalidate();
        }
        HttpSession newSession = request.getSession(true);
        ActionContext.setSession((Map)new SessionMap(newSession));
        try {
            this.staticDependencies.getAuthenticator().logout(request, response);
        }
        catch (AuthenticatorException e) {
            log.error((Object)e);
        }
        loggerSecurityEvents.info((Object)("The user '" + userName + "' has logged out."));
        this.jiraAuthenticationContext.setLoggedInUser(null);
        request.setAttribute("jira.logout.page.executed", (Object)Boolean.TRUE);
    }

    @Override
    public boolean isElevatedSecurityCheckAlwaysShown() {
        return this.getMaxAuthenticationAttemptsAllowed() <= 0L;
    }

    @Override
    public void resetFailedLoginCount(User user) {
        this.loginStore.resetFailedLoginCount(user);
    }

    protected Set<DeniedReason> getLoginDeniedReasons(HttpServletRequest request) {
        HashSet loginDeniedDueTo = Sets.newHashSet();
        if (request.getAttribute(ELEVATED_SECURITY_FAILURE) != null) {
            String loginJsp = String.format("%s/login.jsp", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
            loginDeniedDueTo.add(new CaptchaChallengeRequired(loginJsp));
        }
        return loginDeniedDueTo;
    }

    private void logSecurityEvents(String userName, LoginInfo loginInfo, LoginReason reason) {
        if (reason == LoginReason.AUTHENTICATION_DENIED) {
            loggerSecurityEvents.warn((Object)("The user '" + userName + "' is required to answer a CAPTCHA elevated security check.  Failure count equals " + loginInfo.getCurrentFailedLoginCount()));
        } else if (reason == LoginReason.AUTHENTICATED_FAILED) {
            loggerSecurityEvents.warn((Object)("The user '" + userName + "' has FAILED authentication.  Failure count equals " + loginInfo.getCurrentFailedLoginCount()));
        } else if (reason == LoginReason.AUTHORISATION_FAILED) {
            loggerSecurityEvents.warn((Object)("The user '" + userName + "' is NOT AUTHORIZED to perform this request"));
        } else {
            Log4jKit.putUserToMDC(userName);
            loggerSecurityEvents.info((Object)("The user '" + userName + "' has PASSED authentication."));
        }
    }

    private LoginInfo recordLoginAttempt(User user, boolean loginSuccessful) {
        return this.loginStore.recordLoginAttempt(user, loginSuccessful);
    }

    private LoginResultImpl recordLoginResultInRequest(HttpServletRequest httpServletRequest, LoginResultImpl loginResult) {
        httpServletRequest.setAttribute("com.atlassian.jira.security.login.LoginManager.LoginResult", (Object)loginResult);
        return loginResult;
    }

    private LoginInfo tweakLoginInfo(LoginInfo storedLoginInfo) {
        long maxLoginAttempts = this.getMaxAuthenticationAttemptsAllowed();
        boolean elevatedSecurityCheckRequired = this.nvl(storedLoginInfo.getCurrentFailedLoginCount(), 0L) >= maxLoginAttempts;
        return new LoginInfoImpl(storedLoginInfo, elevatedSecurityCheckRequired);
    }

    private long nvl(Long value, long defaultValue) {
        return value == null ? defaultValue : value;
    }

    private long getMaxAuthenticationAttemptsAllowed() {
        return this.loginStore.getMaxAuthenticationAttemptsAllowed();
    }

    private static class InternalStaticDependencies
    implements StaticDependencies {
        final CrowdService crowdService;

        private InternalStaticDependencies(CrowdService crowdService) {
            this.crowdService = crowdService;
        }

        @Override
        public Authenticator getAuthenticator() {
            return SecurityConfigFactory.getInstance().getAuthenticator();
        }

        @Override
        public boolean authenticate(User user, String password) {
            try {
                return this.crowdService.authenticate(user.getName(), password) != null;
            }
            catch (FailedAuthenticationException e) {
                return false;
            }
        }
    }

    static interface StaticDependencies {
        public Authenticator getAuthenticator();

        public boolean authenticate(User var1, String var2);
    }
}

