/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.auth.trustedapps.KeyFactory;
import com.atlassian.jira.security.auth.trustedapps.SimpleTrustedApplication;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationManager;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.security.PublicKey;
import org.apache.commons.lang.StringUtils;

public class TrustedApplicationSemanticValidator
implements TrustedApplicationValidator {
    private final TrustedApplicationManager manager;

    public TrustedApplicationSemanticValidator(TrustedApplicationManager manager) {
        Assertions.notNull("manager", manager);
        this.manager = manager;
    }

    @Override
    public boolean validate(JiraServiceContext context, I18nHelper helper, SimpleTrustedApplication application) {
        if (application.getId() <= 0L) {
            String appId = application.getApplicationId();
            if (!StringUtils.isBlank((String)appId) && this.manager.get(appId) != null) {
                context.getErrorCollection().addErrorMessage(helper.getText("admin.trustedapps.edit.applicationid.already.exists", appId));
            }
        } else if (this.manager.get(application.getId()) == null) {
            context.getErrorCollection().addErrorMessage(helper.getText("admin.trustedapps.edit.id.not.found", String.valueOf(application.getId())));
        }
        PublicKey publicKey = KeyFactory.getPublicKey(application.getPublicKey());
        if (publicKey instanceof KeyFactory.InvalidPublicKey) {
            context.getErrorCollection().addErrorMessage(helper.getText("admin.trustedapps.edit.public.key.invalid", publicKey.toString()));
        }
        return !context.getErrorCollection().hasAnyErrors();
    }
}

