/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

class PermissionsCache {
    private final Map<CacheKey, Collection<Project>> projectObjectsWithBrowsePermissionForUser = new HashMap<CacheKey, Collection<Project>>();
    private final Map<CacheKey, Collection<GenericValue>> projectsWithBrowsePermissionForUser = new HashMap<CacheKey, Collection<GenericValue>>();
    private final ProjectFactory projectFactory;
    private final Function<GenericValue, Project> gvToProjectTransformer = new Function<GenericValue, Project>(){

        @Override
        public Project get(GenericValue projectGv) {
            return PermissionsCache.this.projectFactory.getProject(projectGv);
        }
    };
    private static final Function<Project, GenericValue> projectToGVTransformer = new Function<Project, GenericValue>(){

        @Override
        public GenericValue get(Project project) {
            return project.getGenericValue();
        }
    };

    PermissionsCache(ProjectFactory projectFactory) {
        this.projectFactory = projectFactory;
    }

    Collection<GenericValue> getProjectsWithBrowsePermission(User user) {
        return this.projectsWithBrowsePermissionForUser.get(new CacheKey(user));
    }

    void setProjectsWithBrowsePermission(User user, Collection<GenericValue> projectsWithBrowsePermission) {
        CacheKey cacheKey = new CacheKey(user);
        this.projectsWithBrowsePermissionForUser.put(cacheKey, CollectionUtil.copyAsImmutableList(projectsWithBrowsePermission));
        this.projectObjectsWithBrowsePermissionForUser.put(cacheKey, CollectionUtil.transform(projectsWithBrowsePermission, this.gvToProjectTransformer));
    }

    Collection<Project> getProjectObjectsWithBrowsePermission(User user) {
        return this.projectObjectsWithBrowsePermissionForUser.get(new CacheKey(user));
    }

    void setProjectObjectsWithBrowsePermission(User user, Collection<Project> projectsWithBrowsePermission) {
        CacheKey cacheKey = new CacheKey(user);
        this.projectObjectsWithBrowsePermissionForUser.put(cacheKey, CollectionUtil.copyAsImmutableList(projectsWithBrowsePermission));
        this.projectsWithBrowsePermissionForUser.put(cacheKey, CollectionUtil.transform(projectsWithBrowsePermission, projectToGVTransformer));
    }

    private static final class CacheKey {
        private final String username;

        CacheKey(User user) {
            this.username = user != null ? user.getName() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.username == null ? cacheKey.username == null : this.username.equals(cacheKey.username);
        }

        public int hashCode() {
            return this.username != null ? this.username.hashCode() : 0;
        }
    }
}

