/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.seraph.auth.AuthenticationContext;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class JiraAuthenticationContextImpl
implements JiraAuthenticationContext {
    private static final ThreadLocal<Map<String, Object>> REQUEST_CACHE = new ThreadLocal();
    private final AuthenticationContext authenticationContext;
    private final I18nHelper.BeanFactory i18n;

    public static void clearRequestCache() {
        REQUEST_CACHE.set(null);
    }

    public static Map<String, Object> getRequestCache() {
        Map<String, Object> cache = REQUEST_CACHE.get();
        if (cache == null) {
            cache = new HashMap<String, Object>();
            REQUEST_CACHE.set(cache);
        }
        return cache;
    }

    public JiraAuthenticationContextImpl(AuthenticationContext authenticationContext, I18nHelper.BeanFactory i18n) {
        this.authenticationContext = authenticationContext;
        this.i18n = i18n;
    }

    @Override
    public User getLoggedInUser() {
        return (User)this.authenticationContext.getUser();
    }

    @Override
    public User getUser() {
        return this.getLoggedInUser();
    }

    @Override
    public Locale getLocale() {
        return I18nBean.getLocaleFromUser(this.getLoggedInUser());
    }

    @Override
    public OutlookDate getOutlookDate() {
        return ComponentAccessor.getComponentOfType(OutlookDateManager.class).getOutlookDate(this.getLocale());
    }

    @Override
    public String getText(String key) {
        return this.getI18nHelper().getText(key);
    }

    @Override
    public I18nHelper getI18nHelper() {
        return this.i18n.getInstance(I18nBean.getLocaleFromUser(this.getLoggedInUser()));
    }

    @Override
    public I18nHelper getI18nBean() {
        return this.getI18nHelper();
    }

    @Override
    public void setLoggedInUser(User user) {
        String userName = user == null ? null : user.getName();
        Log4jKit.putUserToMDC(userName);
        if (LoginLoggers.LOGIN_SETAUTHCTX_LOG.isDebugEnabled()) {
            LoginLoggers.LOGIN_SETAUTHCTX_LOG.debug((Object)("Setting JIRA Auth Context to be  '" + (StringUtils.isBlank((String)userName) ? "anonymous" : userName) + "'"));
        }
        this.authenticationContext.setUser((Principal)user);
    }
}

