/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.mapper;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.mapper.GroupToRoleMapping;
import com.atlassian.jira.scheme.mapper.RoleToGroupsMapping;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.set.ListOrderedSet;

public class SchemeTransformResult {
    private Collection projects;
    private Map roleToGroupsMappingByProjectRole;
    private Scheme originalScheme;
    private Scheme transformedScheme;
    private Scheme resultingScheme;

    public SchemeTransformResult(Scheme originalScheme) {
        this.originalScheme = originalScheme;
        this.roleToGroupsMappingByProjectRole = new TreeMap(ProjectRoleComparator.COMPARATOR);
    }

    public boolean originalSchemeTransformed() {
        return this.getTransformedScheme() != null;
    }

    public Scheme getTransformedScheme() {
        if (this.transformedScheme == null) {
            this.transformedScheme = new Scheme(this.originalScheme.getId(), this.originalScheme.getType(), this.originalScheme.getName(), this.originalScheme.getDescription(), new ArrayList<SchemeEntity>(this.originalScheme.getEntities()));
            HashSet entitiesToRemove = new HashSet();
            HashSet entitiesToAdd = new HashSet();
            this.determineSchemeEntitiesToAddAndRemove(entitiesToAdd, entitiesToRemove);
            if (entitiesToRemove.isEmpty() && entitiesToAdd.isEmpty()) {
                this.transformedScheme = null;
            } else {
                ListOrderedSet entities = new ListOrderedSet();
                entities.addAll(this.transformedScheme.getEntities());
                entities.removeAll(entitiesToRemove);
                entities.addAll(entitiesToAdd);
                this.transformedScheme.setEntities((Collection<SchemeEntity>)entities);
            }
        }
        return this.transformedScheme;
    }

    public Scheme getOriginalScheme() {
        return this.originalScheme;
    }

    public Collection getAssociatedProjects() {
        if (this.projects == null) {
            return Collections.EMPTY_LIST;
        }
        return this.projects;
    }

    public void setAssociatedProjects(Collection projects) {
        this.projects = projects;
    }

    public void addRoleMappingForGroup(GroupToRoleMapping groupToRoleMapping, Group group) {
        RoleToGroupsMapping roleToGroupsMapping = (RoleToGroupsMapping)this.roleToGroupsMappingByProjectRole.get(groupToRoleMapping.getProjectRole());
        if (roleToGroupsMapping == null) {
            roleToGroupsMapping = new RoleToGroupsMapping(groupToRoleMapping);
            this.roleToGroupsMappingByProjectRole.put(groupToRoleMapping.getProjectRole(), roleToGroupsMapping);
        }
        if (this.isGroupinSchemeEntities(group.getName())) {
            roleToGroupsMapping.addMappedGroup(group);
        }
    }

    private boolean isGroupinSchemeEntities(String groupName) {
        for (SchemeEntity schemeEntity : this.originalScheme.getEntities()) {
            if (!"group".equals(schemeEntity.getType()) && !"Group_Dropdown".equals(schemeEntity.getType()) || !groupName.equals(schemeEntity.getParameter())) continue;
            return true;
        }
        return false;
    }

    public Collection getRoleToGroupsMappings() {
        return this.roleToGroupsMappingByProjectRole.values();
    }

    private void determineSchemeEntitiesToAddAndRemove(Set entitiesToAdd, Set entitiesToRemove) {
        for (SchemeEntity schemeEntity : this.transformedScheme.getEntities()) {
            String groupName = schemeEntity.getParameter();
            if (!"group".equals(schemeEntity.getType()) && !"Group_Dropdown".equals(schemeEntity.getType())) continue;
            boolean matchedGroup = false;
            for (RoleToGroupsMapping roleToGroupsMapping : this.roleToGroupsMappingByProjectRole.values()) {
                ProjectRole projectRole = roleToGroupsMapping.getProjectRole();
                if (projectRole == null || groupName == null || !roleToGroupsMapping.getMappedGroupNames().contains(groupName)) continue;
                boolean isNotification = "NotificationScheme".equals(this.transformedScheme.getType());
                String entityType = isNotification ? "Project_Role" : "projectrole";
                SchemeEntity projectRoleSchemeEntity = new SchemeEntity(null, entityType, projectRole.getId().toString(), schemeEntity.getEntityTypeId(), schemeEntity.getTemplateId(), null);
                entitiesToAdd.add(projectRoleSchemeEntity);
                matchedGroup = true;
            }
            if (!matchedGroup) continue;
            entitiesToRemove.add(schemeEntity);
        }
    }

    public Scheme getResultingScheme() {
        return this.resultingScheme;
    }

    public void setResultingScheme(Scheme resultingScheme) {
        this.resultingScheme = resultingScheme;
    }
}

