/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.mapper;

import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.mapper.GroupToRoleMapping;
import com.atlassian.jira.scheme.mapper.RoleToGroupsMapping;
import com.atlassian.jira.scheme.mapper.SchemeGroupsToRolesTransformer;
import com.atlassian.jira.scheme.mapper.SchemeTransformResult;
import com.atlassian.jira.scheme.mapper.SchemeTransformResults;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class SchemeGroupsToRolesTransformerImpl
implements SchemeGroupsToRolesTransformer {
    private static final Logger log = Logger.getLogger(SchemeGroupsToRolesTransformerImpl.class);
    private final SchemeManagerFactory schemeManagerFactory;
    private final ProjectRoleManager projectRoleManager;
    private final GroupManager groupManager;
    private final RoleActorFactory roleActorFactory;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private static final String BACKUP_OF = "Backup of ";

    public SchemeGroupsToRolesTransformerImpl(SchemeManagerFactory schemeManagerFactory, ProjectRoleManager projectRoleManager, RoleActorFactory roleActorFactory, IssueSecurityLevelManager issueSecurityLevelManager, GroupManager groupManager) {
        this.schemeManagerFactory = schemeManagerFactory;
        this.projectRoleManager = projectRoleManager;
        this.roleActorFactory = roleActorFactory;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.groupManager = groupManager;
    }

    @Override
    public SchemeTransformResults doTransform(List schemes, Set groupToRoleMappings) {
        SchemeTransformResults schemeTransformResults = new SchemeTransformResults();
        for (Scheme scheme : schemes) {
            schemeTransformResults.addResult(this.transformScheme(scheme, groupToRoleMappings));
        }
        return schemeTransformResults;
    }

    @Override
    public void persistTransformationResults(SchemeTransformResults schemeTransformResults) {
        for (SchemeTransformResult schemeTransformResult : schemeTransformResults.getAllSchemeTransformResults()) {
            this.persistSchemeTransformResult(schemeTransformResult);
        }
    }

    private void persistSchemeTransformResult(SchemeTransformResult schemeTransformResult) {
        this.persistUsersToRoleActors(schemeTransformResult);
        this.backupOriginalScheme(schemeTransformResult);
        this.persistTransformedScheme(schemeTransformResult);
    }

    private void backupOriginalScheme(SchemeTransformResult schemeTransformResult) {
        Scheme originalScheme = schemeTransformResult.getOriginalScheme();
        SchemeManager schemeManager = this.schemeManagerFactory.getSchemeManager(originalScheme.getType());
        String newName = this.getValidBackupNameForScheme(BACKUP_OF + schemeTransformResult.getOriginalScheme().getName(), schemeManager, 1);
        originalScheme.setName(newName);
        schemeManager.updateScheme(originalScheme);
    }

    private String getValidBackupNameForScheme(String schemeName, SchemeManager schemeManager, int count) {
        try {
            if (schemeManager.getScheme(schemeName) != null) {
                return this.getValidBackupNameForScheme(schemeName + " (" + count + ")", schemeManager, count + 1);
            }
        }
        catch (GenericEntityException e) {
            log.warn((Object)("Unable to resolve scheme with name: " + schemeName), (Throwable)e);
        }
        return schemeName;
    }

    private void persistTransformedScheme(SchemeTransformResult schemeTransformResult) {
        Scheme transformedScheme = schemeTransformResult.getTransformedScheme();
        SchemeManager schemeManager = this.schemeManagerFactory.getSchemeManager(transformedScheme.getType());
        Scheme scheme = schemeManager.createSchemeAndEntities(transformedScheme);
        schemeTransformResult.setResultingScheme(scheme);
        this.modifyAllProjectAssociations(schemeManager, schemeTransformResult);
    }

    private void modifyAllProjectAssociations(SchemeManager schemeManager, SchemeTransformResult schemeResult) {
        for (Project project : schemeResult.getAssociatedProjects()) {
            schemeManager.removeSchemesFromProject(project);
            schemeManager.addSchemeToProject(project, schemeResult.getResultingScheme());
        }
    }

    private void persistUsersToRoleActors(SchemeTransformResult schemeTransformResult) {
        for (RoleToGroupsMapping roleToGroupsMapping : schemeTransformResult.getRoleToGroupsMappings()) {
            Collection associatedProjects = schemeTransformResult.getAssociatedProjects();
            this.updateRoleActorsForProjects(roleToGroupsMapping, associatedProjects);
        }
    }

    private void updateRoleActorsForProjects(RoleToGroupsMapping roleToGroupsMapping, Collection associatedProjects) {
        ProjectRole projectRole = roleToGroupsMapping.getProjectRole();
        for (Project project : associatedProjects) {
            ProjectRoleActors projectRoleActors = this.projectRoleManager.getProjectRoleActors(projectRole, project);
            Collection users = roleToGroupsMapping.getUnpackedUsers();
            HashSet<RoleActor> set = new HashSet<RoleActor>(users.size());
            for (String userName : users) {
                ProjectRoleActor roleActor = null;
                try {
                    roleActor = this.roleActorFactory.createRoleActor(null, projectRole.getId(), project.getId(), "atlassian-user-role-actor", userName);
                }
                catch (RoleActorDoesNotExistException e) {
                    throw new IllegalArgumentException("Unexpected error: the user '" + userName + "' does not exist.");
                }
                set.add(roleActor);
            }
            projectRoleActors = (ProjectRoleActors)projectRoleActors.addRoleActors(set);
            this.projectRoleManager.updateProjectRoleActors(projectRoleActors);
            this.clearIssueSecurityLevelCache();
        }
    }

    private SchemeTransformResult transformScheme(Scheme scheme, Set groupToRoleMappings) {
        SchemeTransformResult schemeTransformResult = new SchemeTransformResult(scheme);
        SchemeManager schemeManager = this.getSchemeManager(scheme.getType());
        if (scheme.getId() != null) {
            schemeTransformResult.setAssociatedProjects(schemeManager.getProjects(scheme));
        }
        for (GroupToRoleMapping groupToRoleMapping : groupToRoleMappings) {
            schemeTransformResult.addRoleMappingForGroup(groupToRoleMapping, this.groupManager.getGroup(groupToRoleMapping.getGroupName()));
        }
        return schemeTransformResult;
    }

    private SchemeManager getSchemeManager(String type) {
        return this.schemeManagerFactory.getSchemeManager(type);
    }

    private void clearIssueSecurityLevelCache() {
        try {
            if (this.issueSecurityLevelManager != null) {
                this.issueSecurityLevelManager.clearUsersLevels();
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.debug((Object)"Unsupported operation was thrown when trying to clear the issue security level manager cache", (Throwable)uoe);
        }
    }
}

