/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.distiller;

import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class SchemeRelationship {
    private Object entityType;
    private String entityTypeDisplayName;
    private Map schemeEntitiesByScheme;
    private boolean allMatch;
    private Collection intersectingEntities;
    private Map nonIntersectingEntities;

    public SchemeRelationship(Object entityType, String entityTypeDisplayName, Collection schemes) {
        this.entityType = entityType;
        this.entityTypeDisplayName = entityTypeDisplayName;
        this.allMatch = this.doAllSchemesMatchForEntityTypeId(schemes, entityType);
        this.nonIntersectingEntities = new HashMap();
        this.schemeEntitiesByScheme = this.initEntitiesByScheme(schemes, entityType);
    }

    public boolean allMatch() {
        return this.allMatch;
    }

    public List getSchemeEntities(Scheme scheme) {
        List entities = (List)this.schemeEntitiesByScheme.get(scheme);
        Collections.sort(entities);
        if (entities == null) {
            entities = Collections.EMPTY_LIST;
        }
        return entities;
    }

    public Collection getMatchingSchemeEntities() {
        if (this.intersectingEntities == null) {
            for (Scheme key : this.schemeEntitiesByScheme.keySet()) {
                List schemeEntities = (List)this.schemeEntitiesByScheme.get(key);
                if (this.intersectingEntities == null) {
                    this.intersectingEntities = schemeEntities;
                    continue;
                }
                this.intersectingEntities = CollectionUtils.intersection((Collection)schemeEntities, (Collection)this.intersectingEntities);
            }
        }
        return this.intersectingEntities;
    }

    public Collection getNonMatchingSchemeEntities(Scheme scheme) {
        ArrayList result = (ArrayList)this.nonIntersectingEntities.get(scheme);
        if (result == null) {
            List schemeEntities = (List)this.schemeEntitiesByScheme.get(scheme);
            result = new ArrayList(schemeEntities);
            result.removeAll(this.getMatchingSchemeEntities());
            this.nonIntersectingEntities.put(scheme, result);
        }
        return result;
    }

    public Map getSchemeEntitiesByScheme() {
        return this.schemeEntitiesByScheme;
    }

    public String getEntityTypeDisplayName() {
        return this.entityTypeDisplayName;
    }

    public Object getEntityType() {
        return this.entityType;
    }

    public Set getAllSchemeEntities() {
        HashSet ret = new HashSet();
        for (Scheme scheme : this.schemeEntitiesByScheme.keySet()) {
            ret.addAll((List)this.schemeEntitiesByScheme.get(scheme));
        }
        return ret;
    }

    private boolean doAllSchemesMatchForEntityTypeId(Collection schemes, Object entityTypeId) {
        HashSet<HashSet<SchemeEntity>> sameEntities = new HashSet<HashSet<SchemeEntity>>();
        for (Scheme scheme : schemes) {
            List<SchemeEntity> entitiesByType = scheme.getEntitiesByType(entityTypeId);
            sameEntities.add(new HashSet<SchemeEntity>(entitiesByType));
            if (sameEntities.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private Map initEntitiesByScheme(Collection schemes, Object entityType) {
        HashMap<Scheme, List<SchemeEntity>> entitiesByScheme = new HashMap<Scheme, List<SchemeEntity>>();
        for (Scheme scheme : schemes) {
            entitiesByScheme.put(scheme, scheme.getEntitiesByType(entityType));
        }
        return entitiesByScheme;
    }
}

