/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.distiller;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.PermissionImpl;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResults;
import com.atlassian.jira.scheme.distiller.SchemeDistiller;
import com.atlassian.jira.scheme.distiller.SchemeEntityType;
import com.atlassian.jira.scheme.distiller.SchemeRelationships;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;

public class SchemeDistillerImpl
implements SchemeDistiller {
    private SchemeManagerFactory schemeManagerFactory;
    private SchemePermissions schemePermissions;
    private EventTypeManager eventTypeManager;

    public SchemeDistillerImpl(SchemeManagerFactory schemeManagerFactory, SchemePermissions schemePermissions, EventTypeManager eventTypeManager) {
        this.schemeManagerFactory = schemeManagerFactory;
        this.schemePermissions = schemePermissions;
        this.eventTypeManager = eventTypeManager;
    }

    @Override
    public Scheme persistNewSchemeMappings(DistilledSchemeResult distilledSchemeResult) throws DataAccessException {
        SchemeManager schemeManager = this.schemeManagerFactory.getSchemeManager(distilledSchemeResult.getType());
        distilledSchemeResult.getResultingScheme().setName(distilledSchemeResult.getResultingSchemeTempName());
        Scheme scheme = schemeManager.createSchemeAndEntities(distilledSchemeResult.getResultingScheme());
        distilledSchemeResult.setResultingScheme(scheme);
        this.modifyAllProjectAssociations(schemeManager, distilledSchemeResult);
        return scheme;
    }

    @Override
    public SchemeRelationships getSchemeRelationships(DistilledSchemeResults distilledSchemeResults) {
        SchemeRelationships schemeRelationships = null;
        String schemeType = distilledSchemeResults.getSchemeType();
        if ("NotificationScheme".equals(schemeType)) {
            Map schemeTypes = this.eventTypeManager.getEventTypesMap();
            schemeRelationships = new SchemeRelationships(distilledSchemeResults.getDistilledSchemeResults(), distilledSchemeResults.getUnDistilledSchemes(), this.getNotificationTypes(schemeTypes));
        } else if ("PermissionScheme".equals(schemeType)) {
            Map<Integer, Permission> schemeTypes = this.schemePermissions.getSchemePermissions();
            schemeRelationships = new SchemeRelationships(distilledSchemeResults.getDistilledSchemeResults(), distilledSchemeResults.getUnDistilledSchemes(), this.getPermissionTypes(schemeTypes));
        }
        return schemeRelationships;
    }

    private Collection getNotificationTypes(Map events) {
        ArrayList<SchemeEntityType> notificationTypes = new ArrayList<SchemeEntityType>();
        for (Map.Entry entry : events.entrySet()) {
            EventType eventType = (EventType)entry.getValue();
            notificationTypes.add(new SchemeEntityType(entry.getKey(), eventType.getNameKey()));
        }
        return notificationTypes;
    }

    private Collection getPermissionTypes(Map permissions) {
        ArrayList<SchemeEntityType> permissionTypes = new ArrayList<SchemeEntityType>();
        for (Map.Entry entry : permissions.entrySet()) {
            Integer key = (Integer)entry.getKey();
            Long realKey = new Long(key.longValue());
            PermissionImpl permission = (PermissionImpl)entry.getValue();
            permissionTypes.add(new SchemeEntityType(realKey, permission.getNameKey()));
        }
        return permissionTypes;
    }

    private void modifyAllProjectAssociations(SchemeManager schemeManager, DistilledSchemeResult distilledSchemeResult) {
        for (Project project : distilledSchemeResult.getAllAssociatedProjects()) {
            schemeManager.removeSchemesFromProject(project);
            schemeManager.addSchemeToProject(project, distilledSchemeResult.getResultingScheme());
        }
    }

    @Override
    public DistilledSchemeResults distillSchemes(Collection schemes) {
        if (schemes == null) {
            return new DistilledSchemeResults(null);
        }
        String type = null;
        if (!schemes.isEmpty()) {
            type = ((Scheme)schemes.iterator().next()).getType();
        }
        MultiHashMap commonSchemeBucket = new MultiHashMap();
        for (Scheme scheme : schemes) {
            commonSchemeBucket.put(new HashSet<SchemeEntity>(scheme.getEntities()), (Object)scheme);
        }
        DistilledSchemeResults distilledSchemeResults = new DistilledSchemeResults(type);
        Iterator iterator = commonSchemeBucket.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList commonSchemes = new ArrayList((Collection)commonSchemeBucket.get(iterator.next()));
            if (commonSchemes.size() > 1) {
                distilledSchemeResults.addDistilledSchemeResult(this.getDistilledSchemeResult(commonSchemes));
                continue;
            }
            distilledSchemeResults.addUndistilledScheme((Scheme)commonSchemes.get(0));
        }
        return distilledSchemeResults;
    }

    private DistilledSchemeResult getDistilledSchemeResult(List commonSchemes) {
        MultiHashMap projectsByScheme = new MultiHashMap();
        String type = null;
        for (Scheme scheme : commonSchemes) {
            if (type == null) {
                type = scheme.getType();
            }
            for (Project project : this.getProjectsForScheme(scheme, type)) {
                projectsByScheme.put((Object)scheme, (Object)project);
            }
        }
        return new DistilledSchemeResult(type, commonSchemes, (Map)projectsByScheme, ((Scheme)commonSchemes.get(0)).cloneScheme());
    }

    private Collection getProjectsForScheme(Scheme scheme, String type) {
        List projects = null;
        SchemeManager schemeManager = this.schemeManagerFactory.getSchemeManager(type);
        if (scheme.getId() != null) {
            projects = schemeManager.getProjects(scheme);
        }
        if (projects == null) {
            projects = Collections.EMPTY_LIST;
        }
        return projects;
    }
}

