/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.scheme.AbstractSchemeAwareAction;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.notification.ProjectAware;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractSelectProjectScheme
extends AbstractSchemeAwareAction
implements ProjectAware {
    private String[] schemeIds = new String[]{""};
    private Long projectId;
    private GenericValue project;

    public String doDefault() throws Exception {
        List<GenericValue> schemes = this.getSchemeManager().getSchemes(this.getProject());
        if (schemes.size() != 0) {
            this.schemeIds = new String[schemes.size()];
            for (int i = 0; i < schemes.size(); ++i) {
                GenericValue scheme = schemes.get(i);
                this.schemeIds[i] = scheme.getLong("id").toString();
            }
        }
        if (this.hasPermission()) {
            return super.doDefault();
        }
        return "securitybreach";
    }

    protected void doValidation() {
        if (this.getProjectId() == null) {
            this.addErrorMessage("You must select a project for this scheme");
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.getSchemeManager().removeSchemesFromProject(this.getProject());
        for (int i = 0; i < this.getSchemeIds().length; ++i) {
            String s = this.getSchemeIds()[i];
            if (!TextUtils.stringSet((String)s)) continue;
            GenericValue scheme = this.getSchemeManager().getScheme(new Long(s));
            this.getSchemeManager().addSchemeToProject(this.getProject(), scheme);
        }
        if (this.hasPermission()) {
            return this.getRedirect(this.getProjectReturnUrl());
        }
        return "securitybreach";
    }

    protected String getProjectReturnUrl() throws GenericEntityException {
        return "/plugins/servlet/project-config/" + this.getProject().getString("key") + "/summary";
    }

    protected boolean hasPermission() {
        return ManagerFactory.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public Collection getSchemes() throws GenericEntityException {
        return this.getSchemeManager().getSchemes();
    }

    public String[] getSchemeIds() {
        return this.schemeIds;
    }

    public void setSchemeIds(String[] schemeIds) {
        this.schemeIds = schemeIds;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    public GenericValue getProject() throws GenericEntityException {
        if (this.project == null) {
            this.project = ManagerFactory.getProjectManager().getProject(this.getProjectId());
        }
        return this.project;
    }
}

