/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sal;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.File;
import java.util.Date;

public class JiraApplicationProperties
implements ApplicationProperties {
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JiraHome jiraHome;
    private final com.atlassian.jira.config.properties.ApplicationProperties jiraApplicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;

    public JiraApplicationProperties(VelocityRequestContextFactory velocityRequestContextFactory, JiraHome jiraHome, com.atlassian.jira.config.properties.ApplicationProperties jiraApplicationProperties, BuildUtilsInfo buildUtilsInfo) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.jiraHome = jiraHome;
        this.jiraApplicationProperties = jiraApplicationProperties;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }

    public String getApplicationName() {
        return this.jiraApplicationProperties.getText("jira.title");
    }

    public String getDisplayName() {
        return "JIRA";
    }

    public String getVersion() {
        return this.buildUtilsInfo.getVersion();
    }

    public Date getBuildDate() {
        return this.buildUtilsInfo.getCurrentBuildDate();
    }

    public String getBuildNumber() {
        return this.buildUtilsInfo.getCurrentBuildNumber();
    }

    public File getHomeDirectory() {
        return this.jiraHome.getHome();
    }

    public String getPropertyValue(String key) {
        return this.jiraApplicationProperties.getDefaultBackedString(key);
    }
}

