/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class CachingVersionStore
implements VersionStore,
Startable {
    private static final Logger log = Logger.getLogger(CachingVersionStore.class);
    private final VersionStore delegate;
    private final EventPublisher eventPublisher;
    private volatile Map versionCache;

    public CachingVersionStore(VersionStore delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refreshCache();
    }

    @Override
    public List getAllVersions() {
        return Collections.unmodifiableList(new ArrayList(this.getVersionCache().values()));
    }

    @Override
    public GenericValue getVersion(Long id) {
        return (GenericValue)this.getVersionCache().get(id);
    }

    @Override
    public GenericValue createVersion(Map versionParams) {
        GenericValue version = this.delegate.createVersion(versionParams);
        this.refreshCache();
        return version;
    }

    @Override
    public void storeVersion(Version version) {
        this.delegate.storeVersion(version);
        this.refreshCache();
    }

    @Override
    public void storeVersions(Collection<Version> versions) {
        this.delegate.storeVersions(versions);
        this.refreshCache();
    }

    @Override
    public void deleteVersion(GenericValue versionGV) {
        this.delegate.deleteVersion(versionGV);
        this.refreshCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getVersionCache() {
        Map currentVersionCache = this.versionCache;
        if (currentVersionCache == null) {
            log.debug((Object)"VersionCache is null - getting a lock to initialise the cache.");
            CachingVersionStore cachingVersionStore = this;
            synchronized (cachingVersionStore) {
                if (this.versionCache == null) {
                    this.loadCache();
                } else {
                    log.debug((Object)"VersionCache was created by another thread - no need to initialise.");
                }
                return this.versionCache;
            }
        }
        return currentVersionCache;
    }

    private synchronized void refreshCache() {
        log.debug((Object)"Versions changed - cache refresh required.");
        this.loadCache();
    }

    private synchronized void loadCache() {
        log.debug((Object)"Loading the cache.");
        LinkedHashMap<Long, GenericValue> newVersionCache = new LinkedHashMap<Long, GenericValue>();
        List versions = this.delegate.getAllVersions();
        for (GenericValue version : versions) {
            newVersionCache.put(version.getLong("id"), version);
        }
        log.debug((Object)"Committing new cache.");
        this.versionCache = Collections.unmodifiableMap(newVersionCache);
        log.debug((Object)"Cache load complete.");
    }
}

