/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.order.SortOrder;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class ReleaseNoteManager {
    private static final Logger log = Logger.getLogger(ReleaseNoteManager.class);
    public static final String RELEASE_NOTE_NAME = "jira.releasenotes.templatenames";
    public static final String RELEASE_NOTE_DEFAULT = "jira.releasenotes.default";
    public static final String RELEASE_NOTE_TEMPLATE = "jira.releasenotes.templates";
    public static final String TEMPLATES_DIR = "templates/jira/project/releasenotes/";
    private Map styles;
    private final ApplicationProperties applicationProperties;
    private final VelocityManager velocityManager;
    private final ConstantsManager constantsManager;
    private final SearchProvider searchProvider;
    private final CustomFieldManager customFieldManager;

    public ReleaseNoteManager(ApplicationProperties applicationProperties, VelocityManager velocityManager, ConstantsManager constantsManager, SearchProvider searchProvider, CustomFieldManager customFieldManager) {
        this.applicationProperties = applicationProperties;
        this.velocityManager = velocityManager;
        this.constantsManager = constantsManager;
        this.searchProvider = searchProvider;
        this.customFieldManager = customFieldManager;
    }

    public Map getStyles() {
        if (this.styles == null) {
            this.loadReleaseNoteTemplates();
        }
        return this.styles;
    }

    private List splitString(String strings) {
        if (strings == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> stringList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(strings, ",");
        while (tokenizer.hasMoreTokens()) {
            stringList.add(tokenizer.nextToken().trim());
        }
        return stringList;
    }

    private void loadReleaseNoteTemplates() {
        List allReleaseNoteNames = this.splitString(this.applicationProperties.getDefaultBackedString(RELEASE_NOTE_NAME));
        List allReleaseNoteTemplates = this.splitString(this.applicationProperties.getDefaultBackedString(RELEASE_NOTE_TEMPLATE));
        if (allReleaseNoteTemplates.size() != allReleaseNoteNames.size()) {
            throw new RuntimeException("Error loading release notes; differing numbers of names and templates specified in properties file.");
        }
        this.styles = new HashMap(allReleaseNoteTemplates.size());
        for (int i = 0; i < allReleaseNoteNames.size(); ++i) {
            this.styles.put(allReleaseNoteNames.get(i), allReleaseNoteTemplates.get(i));
        }
    }

    public String getReleaseNote(Action action, String releaseNoteStyleName, Version version, User user, GenericValue project) throws IllegalArgumentException {
        try {
            String defaultType;
            String templateName = (String)this.getStyles().get(releaseNoteStyleName);
            if (templateName == null && StringUtils.isNotBlank((String)(defaultType = this.applicationProperties.getDefaultBackedString(RELEASE_NOTE_DEFAULT)))) {
                templateName = (String)this.getStyles().get(defaultType);
            }
            if (templateName == null) {
                templateName = this.getFirstStyle();
            }
            if (templateName == null) {
                log.error((Object)"No styles available for release notes");
                throw new IllegalArgumentException("No styles available for release notes");
            }
            Map templateVariables = this.getTemplateVariables(action, version, user, project);
            return this.velocityManager.getBody(TEMPLATES_DIR, templateName, templateVariables);
        }
        catch (VelocityException e) {
            log.error((Object)"Exception occurred while attempting to get velocity body for release note template.", (Throwable)e);
            return null;
        }
    }

    private String getFirstStyle() {
        Iterator iterator;
        Collection values = this.getStyles().values();
        if (values != null && (iterator = values.iterator()).hasNext()) {
            return (String)iterator.next();
        }
        return null;
    }

    private Map getTemplateVariables(Action action, Version version, User user, GenericValue project) {
        ArrayList<IssuesByType> issueTypes = new ArrayList<IssuesByType>();
        for (IssueType issueType : this.constantsManager.getAllIssueTypeObjects()) {
            issueTypes.add(new IssuesByType(issueType, user, version.getLong("id")));
        }
        TextUtils textUtils = new TextUtils();
        Map templateVarMap = EasyMap.build((Object[])new Object[]{"action", action, "req", ActionContext.getRequest(), "issueTypes", issueTypes, "appProps", this.applicationProperties, "version", version.getName(), "versionObj", version, "project", project.getString("name"), "textUtils", textUtils, "requestContext", new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext()});
        templateVarMap.put("constantsManager", this.constantsManager);
        templateVarMap.put("customFieldManager", this.customFieldManager);
        return templateVarMap;
    }

    public class IssuesByType {
        private final IssueType issueType;
        private final User user;
        private final Long fixForVersion;
        private Collection issues;

        private IssuesByType(IssueType issueType, @NotNull User user, Long fixForVersion) {
            this.issueType = issueType;
            this.user = user;
            this.fixForVersion = Assertions.notNull("fixForVersion", fixForVersion);
        }

        public String getName() {
            return this.issueType.getNameTranslation();
        }

        public Collection getIssues() {
            if (this.issues == null) {
                JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
                queryBuilder.where().fixVersion(this.fixForVersion).and().issueType(this.issueType.getId());
                queryBuilder.orderBy().issueKey(SortOrder.ASC);
                try {
                    this.issues = ReleaseNoteManager.this.searchProvider.search(queryBuilder.buildQuery(), this.user, PagerFilter.getUnlimitedFilter()).getIssues();
                }
                catch (SearchException e) {
                    log.error((Object)"Error searching for issues", (Throwable)e);
                }
            }
            return this.issues;
        }
    }
}

