/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.browse;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.HashMap;
import java.util.Map;

public class BrowseProjectContext
implements BrowseContext {
    protected Project project;
    private final User user;
    protected TerminalClause projectClause;

    public BrowseProjectContext(User user, Project project) {
        this.project = project;
        this.user = user;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Query createQuery() {
        return new QueryImpl(this.getProjectClause());
    }

    protected TerminalClause getProjectClause() {
        if (this.projectClause == null) {
            this.projectClause = new TerminalClauseImpl("project", Operator.EQUALS, this.getProject().getKey());
        }
        return this.projectClause;
    }

    protected ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    protected SearchService getSearchService() {
        return ComponentManager.getComponent(SearchService.class);
    }

    @Override
    public String getQueryString() {
        QueryImpl query = new QueryImpl(this.getProjectClause());
        return this.getSearchService().getQueryString(this.getUser(), query);
    }

    @Override
    public Map<String, Object> createParameterMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("project", this.getProject());
        map.put("user", this.getUser());
        return map;
    }

    @Override
    public String getContextKey() {
        return this.project.getKey();
    }
}

