/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.NotNull;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public class ProjectImpl
implements Project {
    private final GenericValue projectGV;
    private final String key;
    private User lead;

    public ProjectImpl(GenericValue projectGv) {
        this.projectGV = projectGv;
        this.key = this.getStringFromGV("key");
    }

    @Override
    public Long getId() {
        return this.getLongFromGV("id");
    }

    @Override
    public String getName() {
        return this.getStringFromGV("name");
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getUrl() {
        return this.getStringFromGV("url");
    }

    @Override
    public User getLead() {
        if (this.getLeadUserName() != null && this.lead == null) {
            this.lead = this.getUser(this.getLeadUserName());
        }
        return this.lead;
    }

    @Override
    public User getLeadUser() {
        return this.getLead();
    }

    @Override
    public String getLeadUserName() {
        return this.getStringFromGV("lead");
    }

    @Override
    public String getDescription() {
        return this.getStringFromGV("description");
    }

    @Override
    public Long getAssigneeType() {
        return this.getLongFromGV("assigneetype");
    }

    @Override
    public Long getCounter() {
        return ComponentAccessor.getProjectManager().getCurrentCounterForProject(this.getId());
    }

    @Override
    public Collection<GenericValue> getComponents() {
        return ComponentAccessor.getProjectManager().getComponents(this.projectGV);
    }

    @Override
    public Collection<ProjectComponent> getProjectComponents() {
        return ComponentAccessor.getProjectComponentManager().findAllForProject(this.getId());
    }

    @Override
    public Collection<Version> getVersions() {
        return ComponentAccessor.getVersionManager().getVersions(this.projectGV.getLong("id"));
    }

    @Override
    public Collection<IssueType> getIssueTypes() {
        return ComponentManager.getComponent(IssueTypeSchemeManager.class).getIssueTypesForProject(this);
    }

    @Override
    public GenericValue getProjectCategory() {
        return ComponentAccessor.getProjectManager().getProjectCategoryFromProject(this.projectGV);
    }

    @Override
    @NotNull
    public Avatar getAvatar() {
        return ComponentAccessor.getAvatarManager().getById(this.getLongFromGV("avatar"));
    }

    @Override
    public GenericValue getGenericValue() {
        return this.projectGV;
    }

    private String getStringFromGV(String key) {
        if (this.projectGV != null) {
            return this.projectGV.getString(key);
        }
        return null;
    }

    private Long getLongFromGV(String key) {
        if (this.projectGV != null) {
            return this.projectGV.getLong(key);
        }
        return null;
    }

    private User getUser(String username) {
        return UserUtils.getUserEvenWhenUnknown(username);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (this.getKey() == null) {
            return other.getKey() == null;
        }
        return this.getKey().equals(other.getKey());
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return "Project: " + this.getKey();
    }
}

