/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.comparator.ComponentComparator;
import com.atlassian.jira.project.AbstractProjectManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCache;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class CachingProjectManager
extends AbstractProjectManager
implements Startable {
    private final ProjectManager delegateProjectManager;
    private final ProjectComponentManager projectComponentManager;
    private final ProjectFactory projectFactory;
    private final EventPublisher eventPublisher;
    private final ProjectCache cache;

    public CachingProjectManager(ProjectManager delegateProjectManager, ProjectComponentManager projectComponentManager, ProjectFactory projectFactory, EventPublisher eventPublisher, UserManager userManager, ApplicationProperties applicationProperties) {
        super(userManager, applicationProperties);
        this.delegateProjectManager = delegateProjectManager;
        this.projectComponentManager = projectComponentManager;
        this.projectFactory = projectFactory;
        this.eventPublisher = eventPublisher;
        this.cache = new ProjectCache(true);
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.updateCache();
        this.delegateProjectManager.refresh();
    }

    public void updateCache() {
        this.cache.refresh();
    }

    @Override
    public long getNextId(Project project) {
        long nextId = this.delegateProjectManager.getNextId(project);
        return nextId;
    }

    @Override
    public void refresh() {
        this.updateCache();
        this.delegateProjectManager.refresh();
    }

    @Override
    public GenericValue getProject(Long id) {
        return this.cache.getProject(id);
    }

    @Override
    public Project getProjectObj(Long id) {
        Project project = null;
        GenericValue projectGv = this.cache.getProject(id);
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    @Override
    public GenericValue getProjectByName(String name) {
        return this.cache.getProjectByName(name);
    }

    @Override
    public GenericValue getProjectByKey(String key) {
        return this.cache.getProjectByKey(key);
    }

    @Override
    public Project getProjectObjByKey(String projectKey) {
        Project project = null;
        GenericValue projectGv = this.getProjectByKey(projectKey);
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    @Override
    public Project getProjectObjByKeyIgnoreCase(String projectKey) {
        Project project = null;
        GenericValue projectGv = this.getProjectByKey(projectKey);
        if (projectGv == null) {
            for (Project prj : this.getProjectObjects()) {
                if (!prj.getKey().equalsIgnoreCase(projectKey)) continue;
                project = prj;
                break;
            }
        } else {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    @Override
    public Project getProjectObjByName(String projectName) {
        Project project = null;
        GenericValue projectGv = this.getProjectByName(projectName);
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    @Override
    public GenericValue getComponent(GenericValue project, String name) {
        return this.projectComponentManager.convertToGenericValue(this.projectComponentManager.findByComponentName(project.getLong("id"), name));
    }

    @Override
    public GenericValue getComponent(Long id) {
        try {
            return this.projectComponentManager.convertToGenericValue(this.projectComponentManager.find(id));
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public Collection getComponents(GenericValue project) {
        Collection<ProjectComponent> allComponentsForProject = this.projectComponentManager.findAllForProject(project.getLong("id"));
        ArrayList<GenericValue> componentGVs = new ArrayList<GenericValue>(this.projectComponentManager.convertToGenericValues(allComponentsForProject));
        Collections.sort(componentGVs, new ComponentComparator());
        return componentGVs;
    }

    @Override
    public Collection<GenericValue> getProjects() {
        return this.noNull(this.cache.getProjects());
    }

    @Override
    public List<Project> getProjectObjects() {
        List<Project> projects = this.cache.getProjectObjects();
        if (projects == null) {
            return Collections.emptyList();
        }
        return projects;
    }

    protected Collection noNull(Collection col) {
        if (col == null) {
            return Collections.EMPTY_LIST;
        }
        return col;
    }

    @Override
    public Project createProject(String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId) {
        Project project = this.delegateProjectManager.createProject(name, key, description, lead, url, assigneeType, avatarId);
        this.updateCache();
        return project;
    }

    @Override
    public Project updateProject(Project updatedProject, String name, String description, String lead, String url, Long assigneeType, Long avatarId) {
        Project project = this.delegateProjectManager.updateProject(updatedProject, name, description, lead, url, assigneeType, avatarId);
        this.updateCache();
        return project;
    }

    @Override
    public void removeProjectIssues(Project project) throws RemoveException {
        this.delegateProjectManager.removeProjectIssues(project);
    }

    @Override
    public void removeProject(Project project) {
        this.delegateProjectManager.removeProject(project);
        this.updateCache();
    }

    @Override
    public Collection<GenericValue> getProjectCategories() {
        return this.noNull(this.cache.getProjectCategories());
    }

    @Override
    public Collection<ProjectCategory> getAllProjectCategories() {
        return Entity.PROJECT_CATEGORY.buildList(this.getProjectCategories());
    }

    @Override
    public GenericValue getProjectCategory(Long id) {
        return this.cache.getProjectCategory(id);
    }

    @Override
    public ProjectCategory getProjectCategoryObject(Long id) {
        return Entity.PROJECT_CATEGORY.build(this.cache.getProjectCategory(id));
    }

    @Override
    public void updateProjectCategory(GenericValue projectCat) {
        this.delegateProjectManager.updateProjectCategory(projectCat);
        this.updateCache();
    }

    @Override
    public void updateProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        this.delegateProjectManager.updateProjectCategory(projectCategory);
        this.updateCache();
    }

    @Override
    public Collection<GenericValue> getProjectsFromProjectCategory(GenericValue projectCategory) {
        return this.cache.getProjectsFromProjectCategory(projectCategory);
    }

    @Override
    public Collection<Project> getProjectsFromProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        return this.getProjectObjectsFromProjectCategory(projectCategory.getId());
    }

    @Override
    public Collection<Project> getProjectObjectsFromProjectCategory(Long projectCategoryId) {
        return this.projectFactory.getProjects(this.getProjectsFromProjectCategory(this.getProjectCategory(projectCategoryId)));
    }

    @Override
    public GenericValue getProjectCategoryFromProject(GenericValue project) {
        return this.cache.getProjectCategoryFromProject(project);
    }

    @Override
    public ProjectCategory getProjectCategoryForProject(Project project) {
        GenericValue projectCategoryForProject = this.cache.getProjectCategoryForProject(project);
        if (projectCategoryForProject != null) {
            return Entity.PROJECT_CATEGORY.build(projectCategoryForProject);
        }
        return null;
    }

    @Override
    public Collection<GenericValue> getProjectsWithNoCategory() {
        return this.cache.getProjectsWithNoCategory();
    }

    @Override
    public Collection<Project> getProjectObjectsWithNoCategory() throws DataAccessException {
        return this.projectFactory.getProjects(this.getProjectsWithNoCategory());
    }

    @Override
    public void setProjectCategory(GenericValue project, GenericValue category) {
        this.delegateProjectManager.setProjectCategory(project, category);
        this.updateCache();
    }

    @Override
    public void setProjectCategory(Project project, ProjectCategory category) throws DataAccessException {
        this.delegateProjectManager.setProjectCategory(project, category);
        this.updateCache();
    }

    @Override
    public List<Project> getProjectsLeadBy(User leadUser) {
        return this.delegateProjectManager.getProjectsLeadBy(leadUser);
    }

    @Override
    public Collection<GenericValue> getProjectsByLead(User leadUser) {
        return this.delegateProjectManager.getProjectsByLead(leadUser);
    }

    @Override
    public ProjectCategory createProjectCategory(String name, String description) {
        ProjectCategory projectCategory = this.delegateProjectManager.createProjectCategory(name, description);
        this.updateCache();
        return projectCategory;
    }

    @Override
    public void removeProjectCategory(Long id) {
        this.delegateProjectManager.removeProjectCategory(id);
        this.updateCache();
    }

    @Override
    public long getCurrentCounterForProject(Long id) {
        return this.delegateProjectManager.getCurrentCounterForProject(id);
    }

    @Override
    public void setCurrentCounterForProject(Project project, long counter) {
        this.delegateProjectManager.setCurrentCounterForProject(project, counter);
    }
}

