/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal.gadgets;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpec;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecId;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.portal.gadgets.ExternalGadgetStore;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfbizExternalGadgetStore
implements ExternalGadgetStore {
    public static final String TABLE = "ExternalGadget";
    private final OfBizDelegator ofBizDelegator;

    public OfbizExternalGadgetStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Set<ExternalGadgetSpec> getAllGadgetSpecUris() {
        HashSet<ExternalGadgetSpec> gadgetUris = new HashSet<ExternalGadgetSpec>();
        List<GenericValue> list = this.ofBizDelegator.findAll(TABLE);
        for (GenericValue genericValue : list) {
            String uriString = genericValue.getString("gadgetXml");
            try {
                gadgetUris.add(new ExternalGadgetSpec(ExternalGadgetSpecId.valueOf((String)genericValue.getLong("id").toString()), new URI(uriString)));
            }
            catch (URISyntaxException e) {
                throw new DataAccessException("External gadget with id '" + genericValue.getLong("id") + "' does not have a valid URI: '" + uriString + "'.", e);
            }
        }
        return Collections.unmodifiableSet(gadgetUris);
    }

    @Override
    public ExternalGadgetSpec addGadgetSpecUri(URI uri) {
        Assertions.notNull("uri", uri);
        if (this.containsSpecUri(uri)) {
            throw new IllegalStateException("External Gadget Store already contains URI '" + uri + "'");
        }
        try {
            GenericValue specGV = EntityUtils.createValue(TABLE, EasyMap.build((Object)"gadgetXml", (Object)uri.toASCIIString()));
            return new ExternalGadgetSpec(ExternalGadgetSpecId.valueOf((String)specGV.getLong("id").toString()), URI.create(specGV.getString("gadgetXml")));
        }
        catch (GenericEntityException gee) {
            throw new DataAccessException(gee);
        }
    }

    @Override
    public void removeGadgetSpecUri(ExternalGadgetSpecId id) {
        Assertions.notNull("id", id);
        this.ofBizDelegator.removeByAnd(TABLE, MapBuilder.newBuilder("id", Long.parseLong(id.value())).toMap());
    }

    @Override
    public boolean containsSpecUri(URI uri) {
        Assertions.notNull("uri", uri);
        List<GenericValue> list = this.ofBizDelegator.findByLike(TABLE, MapBuilder.newBuilder().add("gadgetXml", uri.toASCIIString()).toMap(), Collections.<String>emptyList());
        return list != null && !list.isEmpty();
    }

    public static final class Columns {
        public static final String ID = "id";
        public static final String GADGET_XML = "gadgetXml";
    }
}

