/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DatabaseIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationImpl;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfbizPortletConfigurationStore
implements PortletConfigurationStore {
    private static final Logger log = Logger.getLogger(OfbizPortletConfigurationStore.class);
    public static final String TABLE = "PortletConfiguration";
    public static final String USER_PREFERENCES_TABLE = "GadgetUserPreference";
    private final OfBizDelegator delegator;
    private final JiraPropertySetFactory propertySetFactory;

    public OfbizPortletConfigurationStore(OfBizDelegator delegator, JiraPropertySetFactory propertySetFactory) {
        Assertions.notNull("delegator", delegator);
        Assertions.notNull("propertySetFactory", propertySetFactory);
        this.delegator = delegator;
        this.propertySetFactory = propertySetFactory;
    }

    @Override
    public List<PortletConfiguration> getByPortalPage(Long portalPageId) {
        Assertions.notNull("portalPageId", portalPageId);
        List<GenericValue> portletConfigsListGVs = this.delegator.findByAnd(TABLE, EasyMap.build((Object)"portalpage", (Object)portalPageId));
        ArrayList<PortletConfiguration> portletConfigs = new ArrayList<PortletConfiguration>(portletConfigsListGVs.size());
        for (GenericValue portletConfigGV : portletConfigsListGVs) {
            portletConfigs.add(this.createConfigurationFromGv(portletConfigGV));
        }
        return portletConfigs;
    }

    @Override
    public PortletConfiguration getByPortletId(Long portletId) {
        Assertions.notNull("portletId", portletId);
        List<GenericValue> portletConfigsListGVs = this.delegator.findByAnd(TABLE, MapBuilder.singletonMap("id", portletId));
        if (!portletConfigsListGVs.isEmpty()) {
            return this.createConfigurationFromGv(portletConfigsListGVs.get(0));
        }
        return null;
    }

    @Override
    public void delete(PortletConfiguration pc) {
        Assertions.notNull("pc", pc);
        Assertions.notNull("pc.id", pc.getId());
        GenericValue gv = this.getGenericValue(pc);
        if (gv != null) {
            OFBizPropertyUtils.removePropertySet(gv);
            this.delegator.removeValue(gv);
            this.delegator.removeByAnd(USER_PREFERENCES_TABLE, EasyMap.build((Object)"portletconfiguration", (Object)pc.getId()));
        }
    }

    @Override
    public void updateGadgetPosition(Long gadgetId, int row, int column, Long dashboardId) {
        Assertions.notNull("gadgetId", gadgetId);
        Assertions.notNull("dashboardId", dashboardId);
        int rowsUpdated = this.delegator.bulkUpdateByPrimaryKey(TABLE, MapBuilder.newBuilder().add("position", row).add("columnNumber", column).add("portalpage", (Integer)((Object)dashboardId)).toMap(), CollectionBuilder.newBuilder(gadgetId).asList());
        if (rowsUpdated != 1) {
            throw new DataAccessException("Gadget position for gadget with id '" + gadgetId + "' not updated correctly.");
        }
    }

    @Override
    public void updateGadgetColor(Long gadgetId, Color color) {
        Assertions.notNull("gadgetId", gadgetId);
        Assertions.notNull("color", color);
        int rowsUpdated = this.delegator.bulkUpdateByPrimaryKey(TABLE, MapBuilder.singletonMap("color", color.toString()), CollectionBuilder.list(gadgetId));
        if (rowsUpdated != 1) {
            throw new DataAccessException("Gadget color for gadget with id '" + gadgetId + "' not updated correctly.");
        }
    }

    @Override
    public void updateUserPrefs(Long gadgetId, Map<String, String> userPrefs) {
        Assertions.notNull("gadgetId", gadgetId);
        Assertions.notNull("userPrefs", userPrefs);
        this.delegator.removeByAnd(USER_PREFERENCES_TABLE, EasyMap.build((Object)"portletconfiguration", (Object)gadgetId));
        for (Map.Entry<String, String> userPref : userPrefs.entrySet()) {
            try {
                EntityUtils.createValue(USER_PREFERENCES_TABLE, EasyMap.build((Object)"userprefkey", (Object)userPref.getKey(), (Object)"userprefvalue", (Object)userPref.getValue(), (Object)"portletconfiguration", (Object)gadgetId));
            }
            catch (GenericEntityException gee) {
                throw new DataAccessException(gee);
            }
        }
    }

    @Override
    public void store(PortletConfiguration pc) {
        Assertions.notNull("pc", pc);
        Assertions.notNull("pc.id", pc.getId());
        GenericValue gv = this.getGenericValue(pc);
        if (gv == null) {
            throw new IllegalArgumentException("Can't store a portlet configuration that has no database entry.  Must add.");
        }
        gv.set("portalpage", (Object)pc.getDashboardPageId());
        gv.set("columnNumber", (Object)pc.getColumn());
        gv.set("position", (Object)pc.getRow());
        if (pc.getGadgetURI() != null) {
            gv.set("gadgetXml", (Object)pc.getGadgetURI().toASCIIString());
        } else {
            gv.set("gadgetXml", null);
        }
        gv.set("color", (Object)pc.getColor().toString());
        this.updateUserPrefs(pc.getId(), pc.getUserPrefs());
        this.delegator.store(gv);
    }

    @Override
    public PortletConfiguration addGadget(Long portalPageId, Long portletConfigurationId, Integer column, Integer row, URI gadgetXml, Color color, Map<String, String> userPreferences) {
        Assertions.notNull("portalPageId", portalPageId);
        Assertions.notNull("column", column);
        Assertions.notNull("row", row);
        Assertions.notNull("gadgetXml", gadgetXml);
        Assertions.notNull("color", color);
        Assertions.notNull("userPreferences", userPreferences);
        try {
            GenericValue gv = EntityUtils.createValue(TABLE, EasyMap.build((Object)"portalpage", (Object)portalPageId, (Object)"id", (Object)portletConfigurationId, (Object)"columnNumber", (Object)column, (Object)"position", (Object)row, (Object)"gadgetXml", (Object)gadgetXml.toASCIIString(), (Object)"color", (Object)color.name()));
            this.updateUserPrefs(gv.getLong("id"), userPreferences);
            return this.createConfigurationFromGv(gv);
        }
        catch (GenericEntityException gee) {
            throw new DataAccessException(gee);
        }
    }

    @Override
    public EnclosedIterable<PortletConfiguration> getAllPortletConfigurations() {
        Resolver<GenericValue, PortletConfiguration> resolver = new Resolver<GenericValue, PortletConfiguration>(){

            @Override
            public PortletConfiguration get(GenericValue input) {
                return OfbizPortletConfigurationStore.this.createConfigurationFromGv(input);
            }
        };
        return new DatabaseIterable<PortletConfiguration>(-1, (Resolver)resolver){

            @Override
            protected OfBizListIterator createListIterator() {
                return OfbizPortletConfigurationStore.this.delegator.findListIteratorByCondition(OfbizPortletConfigurationStore.TABLE, null);
            }
        };
    }

    private GenericValue getGenericValue(PortletConfiguration pc) {
        return this.delegator.findByPrimaryKey(TABLE, EasyMap.build((Object)"id", (Object)pc.getId()));
    }

    private PortletConfiguration createConfigurationFromGv(GenericValue portletConfigGV) {
        if (portletConfigGV == null) {
            return null;
        }
        Long id = portletConfigGV.getLong("id");
        URI gadgetUri = this.getGadgetXmlURI(portletConfigGV.getString("gadgetXml"), id);
        String colorString = portletConfigGV.getString("color");
        Map<String, String> userPrefs = this.getUserPreferences(id);
        Color gadgetColor = StringUtils.isEmpty((String)colorString) ? null : Color.valueOf((String)colorString);
        return new PortletConfigurationImpl(id, portletConfigGV.getLong("portalpage"), portletConfigGV.getInteger("columnNumber"), portletConfigGV.getInteger("position"), gadgetUri, gadgetColor, userPrefs);
    }

    Map<String, String> getUserPreferences(Long id) {
        HashMap<String, String> ret = new HashMap<String, String>();
        List<GenericValue> list = this.delegator.findByAnd(USER_PREFERENCES_TABLE, MapBuilder.newBuilder().add("portletconfiguration", id).toMap());
        for (GenericValue userPrefGv : list) {
            String value = userPrefGv.getString("userprefvalue");
            if (value == null) {
                value = "";
            }
            ret.put(userPrefGv.getString("userprefkey"), value);
        }
        return ret;
    }

    private URI getGadgetXmlURI(String gadgetXmlString, Long portletId) {
        if (StringUtils.isNotEmpty((String)gadgetXmlString)) {
            try {
                return new URI(gadgetXmlString);
            }
            catch (URISyntaxException e) {
                throw new DataAccessException("Invalid gadget XML URI stored for portlet with id '" + portletId + "': '" + gadgetXmlString + "'", e);
            }
        }
        return null;
    }

    public static final class UserPreferenceColumns {
        public static final String KEY = "userprefkey";
        public static final String VALUE = "userprefvalue";
        public static final String PORTLETID = "portletconfiguration";
    }

    public static final class Columns {
        public static final String COLOR = "color";
        public static final String GADGET_XML = "gadgetXml";
        public static final String PORTALPAGE = "portalpage";
        public static final String PORTLETKEY = "portletId";
        public static final String COLUMN = "columnNumber";
        public static final String ROW = "position";
        public static final String ID = "id";
    }
}

