/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FavouriteDashboardLinkFactory
implements SimpleLinkFactory {
    private static final int MAX_LABEL_LENGTH = 30;
    private final PortalPageService portalPageService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final UserHistoryManager userHistoryManager;

    public FavouriteDashboardLinkFactory(PortalPageService portalPageService, VelocityRequestContextFactory velocityRequestContextFactory, I18nHelper.BeanFactory i18nFactory, UserHistoryManager userHistoryManager) {
        this.portalPageService = portalPageService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.i18nFactory = i18nFactory;
        this.userHistoryManager = userHistoryManager;
    }

    @Override
    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    @Override
    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        Collection<PortalPage> portalPages = this.portalPageService.getFavouritePortalPages(user);
        String baseUrl = requestContext.getBaseUrl();
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        ArrayList<SimpleLink> links = new ArrayList<SimpleLink>();
        if (portalPages == null || portalPages.isEmpty()) {
            links.add(new SimpleLinkImpl("dash_lnk_system", i18n.getText("menu.dashboard.view.system"), i18n.getText("menu.dashboard.view.system.title"), null, null, null, baseUrl + "/secure/Dashboard.jspa", null));
        } else {
            Long currentDash = this.getCurrentDashboard(user);
            for (PortalPage portalPage : portalPages) {
                String title;
                String style = null;
                Long pageId = portalPage.getId();
                String description = portalPage.getDescription();
                String name = portalPage.getName();
                String shortName = name;
                if (shortName.length() > 30) {
                    shortName = shortName.substring(0, 30) + "...";
                }
                String string = title = StringUtils.isBlank((String)description) ? name : i18n.getText("menu.dashboard.title", name, description);
                if (portalPages.size() > 1 && pageId.equals(currentDash)) {
                    style = "bolded";
                }
                links.add(new SimpleLinkImpl("dash_lnk_" + pageId, shortName, title, null, style, null, baseUrl + "/secure/Dashboard.jspa?selectPageId=" + pageId, null));
            }
        }
        return links;
    }

    private Long getCurrentDashboard(User user) {
        List<UserHistoryItem> history = this.userHistoryManager.getHistory(UserHistoryItem.DASHBOARD, user);
        if (!history.isEmpty()) {
            return Long.valueOf(history.get(0).getEntityId());
        }
        return null;
    }
}

