/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.Vote;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.dashboard.permission.GadgetPermissionManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationManager;
import com.atlassian.jira.portal.events.DashboardCreated;
import com.atlassian.jira.portal.events.DashboardDeleted;
import com.atlassian.jira.portal.events.DashboardUpdated;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DefaultPortalPageManager
implements PortalPageManager {
    private final ShareManager shareManager;
    private final PortalPageStore portalPageStore;
    private final PortletConfigurationManager portletConfigurationManager;
    private final SharedEntityIndexer indexer;
    private GadgetPermissionManager gadgetPermissionManager;
    private final EventPublisher eventPublisher;
    private final JiraAuthenticationContext authenticationContext;
    private final Resolver<PortalPage, PortalPage> permissionResolver = new Resolver<PortalPage, PortalPage>(){

        @Override
        public PortalPage get(PortalPage portalPage) {
            return DefaultPortalPageManager.this.setRelatedState(portalPage);
        }
    };

    public DefaultPortalPageManager(ShareManager shareManager, PortalPageStore portalPageStore, PortletConfigurationManager portletConfigurationManager, SharedEntityIndexer indexer, EventPublisher eventPublisher, JiraAuthenticationContext authenticationContext) {
        this.shareManager = shareManager;
        this.portalPageStore = portalPageStore;
        this.portletConfigurationManager = portletConfigurationManager;
        this.indexer = indexer;
        this.eventPublisher = eventPublisher;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public SharedEntity.TypeDescriptor<PortalPage> getType() {
        return PortalPage.ENTITY_TYPE;
    }

    @Override
    public void adjustFavouriteCount(SharedEntity entity, int adjustmentValue) {
        Assertions.notNull("entity", entity);
        Assertions.equals("PortalPage type", PortalPage.ENTITY_TYPE, entity.getEntityType());
        PortalPage portalPage = this.portalPageStore.adjustFavouriteCount(entity, adjustmentValue);
        this.indexer.index(this.setRelatedState(portalPage)).await();
    }

    @Override
    public PortalPage getSharedEntity(Long entityId) {
        Assertions.notNull("entityId", entityId);
        return this.getPortalPageById(entityId);
    }

    @Override
    public PortalPage getSharedEntity(User user, Long entityId) {
        Assertions.notNull("entityId", entityId);
        return this.getPortalPage(user, entityId);
    }

    @Override
    public boolean hasPermissionToUse(User user, PortalPage portalPage) {
        Assertions.notNull("portalPage", portalPage);
        return portalPage.isSystemDefaultPortalPage() || this.isSharedWith(portalPage, user);
    }

    @Override
    public EnclosedIterable<PortalPage> getAll() {
        return Transformed.enclosedIterable(this.portalPageStore.getAll(), this.permissionResolver);
    }

    @Override
    public EnclosedIterable<SharedEntity> getAllIndexableSharedEntities() {
        EnclosedIterable<SharedEntity> all = this.getAll();
        return all;
    }

    @Override
    public EnclosedIterable<PortalPage> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return Transformed.enclosedIterable(this.portalPageStore.get(descriptor), this.permissionResolver);
    }

    @Override
    public EnclosedIterable<PortalPage> get(User user, SharedEntityAccessor.RetrievalDescriptor ids) {
        return this.get(ids);
    }

    @Override
    public Collection<PortalPage> getAllOwnedPortalPages(User owner) {
        Assertions.notNull("owner", owner);
        Assertions.notNull("owner.name", owner.getName());
        Collection<PortalPage> portalPages = this.portalPageStore.getAllOwnedPortalPages(owner);
        if (portalPages == null) {
            return Collections.emptyList();
        }
        return this.setRelatedState(portalPages);
    }

    @Override
    public PortalPage getPortalPageByName(User owner, String pageName) {
        Assertions.notNull("owner", owner);
        Assertions.notNull("owner,name", owner.getName());
        Assertions.notNull("pageName", pageName);
        PortalPage portalPage = this.portalPageStore.getPortalPageByOwnerAndName(owner, pageName);
        return this.setRelatedState(portalPage);
    }

    @Override
    public PortalPage getSystemDefaultPortalPage() {
        PortalPage systemDefaultPortalPage = this.portalPageStore.getSystemDefaultPortalPage();
        return this.setRelatedState(systemDefaultPortalPage);
    }

    @Override
    public PortalPage getPortalPage(User user, Long id) {
        Assertions.notNull("id", id);
        PortalPage portalPage = this.portalPageStore.getPortalPage(id);
        if (portalPage == null) {
            return null;
        }
        if (!this.hasPermissionToUse(user, portalPage)) {
            return null;
        }
        return this.setRelatedState(portalPage);
    }

    @Override
    public PortalPage getPortalPageById(Long portalPageId) {
        Assertions.notNull("portalPageId", portalPageId);
        PortalPage portalPage = this.portalPageStore.getPortalPage(portalPageId);
        return this.setRelatedState(portalPage);
    }

    @Override
    public PortalPage create(PortalPage portalPage) {
        this.assertCreate(portalPage);
        PortalPage createdPortalPage = PortalPage.portalPage(this.portalPageStore.create(portalPage)).permissions(portalPage.getPermissions()).build();
        this.shareManager.updateSharePermissions(createdPortalPage);
        this.indexer.index(createdPortalPage).await();
        this.eventPublisher.publish((Object)new DashboardCreated(createdPortalPage, this.authenticationContext.getLoggedInUser()));
        return createdPortalPage;
    }

    @Override
    public PortalPage createBasedOnClone(User pageOwner, PortalPage portalPage, PortalPage clonePortalPage) {
        this.assertCreate(portalPage);
        Assertions.notNull("clonePortalPage", clonePortalPage);
        PortalPage portalPageToCreate = PortalPage.portalPage(portalPage).layout(clonePortalPage.getLayout()).build();
        PortalPage newPortalPage = this.create(portalPageToCreate);
        this.clonePortletsFromOnePageToAnother(pageOwner, clonePortalPage, newPortalPage);
        this.eventPublisher.publish((Object)new DashboardCreated(newPortalPage, this.authenticationContext.getLoggedInUser()));
        return newPortalPage;
    }

    @Override
    public PortalPage update(PortalPage portalPage) {
        this.assertCreate(portalPage);
        Assertions.notNull("portalPage.id", portalPage.getId());
        PortalPage newPortalPage = PortalPage.portalPage(this.portalPageStore.update(portalPage)).permissions(portalPage.getPermissions()).build();
        this.shareManager.updateSharePermissions(newPortalPage);
        this.indexer.index(newPortalPage).await();
        this.eventPublisher.publish((Object)new DashboardUpdated(portalPage, newPortalPage, this.authenticationContext.getLoggedInUser()));
        return newPortalPage;
    }

    public void deleteAllPortalPagesForUser(User user) {
        Collection<PortalPage> ownedPortalPages = this.getAllOwnedPortalPages(user);
        for (PortalPage portalPage : ownedPortalPages) {
            this.delete(portalPage.getId());
        }
    }

    @Override
    public void delete(Long portalPageId) {
        Assertions.notNull("portalPageId", portalPageId);
        List<PortletConfiguration> portlectConfigurations = this.portletConfigurationManager.getByPortalPage(portalPageId);
        for (PortletConfiguration portletConfiguration : portlectConfigurations) {
            this.portletConfigurationManager.delete(portletConfiguration);
        }
        SharedEntity.Identifier identifier = new SharedEntity.Identifier(portalPageId, PortalPage.ENTITY_TYPE, (String)null);
        this.portalPageStore.delete(portalPageId);
        this.shareManager.deletePermissions(identifier);
        this.indexer.deIndex(identifier).await();
        this.eventPublisher.publish((Object)new DashboardDeleted(identifier, this.authenticationContext.getLoggedInUser()));
    }

    @Override
    public void saveLegacyPortletConfiguration(PortletConfiguration portletConfiguration) {
        Assertions.notNull("portletConfiguration", portletConfiguration);
        Long id = portletConfiguration.getId();
        PortletConfiguration pc = this.portletConfigurationManager.getByPortletId(id);
        if (pc == null) {
            throw new IllegalStateException("Trying to update portletConfiguration that doesn't exist with id '" + id + "'.");
        }
        this.portletConfigurationManager.store(portletConfiguration);
    }

    @Override
    public SharedEntitySearchResult<PortalPage> search(SharedEntitySearchParameters searchParameters, User user, int pagePosition, int pageWidth) {
        Assertions.notNull("searchParameters", searchParameters);
        Assertions.not("pagePosition < 0", pagePosition < 0);
        Assertions.not("pageWidth <= 0", pageWidth <= 0);
        return this.indexer.getSearcher(PortalPage.ENTITY_TYPE).search(searchParameters, user, pagePosition, pageWidth);
    }

    @Override
    public List<List<PortletConfiguration>> getPortletConfigurations(Long portalPageId) {
        ArrayList<List<PortletConfiguration>> columns = new ArrayList<List<PortletConfiguration>>();
        List<PortletConfiguration> portletConfigurations = this.portletConfigurationManager.getByPortalPage(portalPageId);
        PortalPage portalPage = this.getPortalPageById(portalPageId);
        if (portalPage != null && !portletConfigurations.isEmpty()) {
            this.initColumns(portalPage.getLayout().getNumberOfColumns(), columns);
            for (PortletConfiguration portletConfiguration : portletConfigurations) {
                int column = portletConfiguration.getColumn();
                ((List)columns.get(column)).add(portletConfiguration);
            }
            for (int i = 0; i < columns.size(); ++i) {
                List column = (List)columns.get(i);
                Collections.sort(column);
                columns.set(i, Collections.unmodifiableList(column));
            }
        }
        return Collections.unmodifiableList(columns);
    }

    private void initColumns(int numberOfColumns, List<List<PortletConfiguration>> columns) {
        for (int i = 0; i < numberOfColumns; ++i) {
            columns.add(new ArrayList());
        }
    }

    private void clonePortletsFromOnePageToAnother(User owner, PortalPage clonePortalPage, PortalPage targetPortalPage) {
        Assertions.notNull("owner", owner);
        Assertions.notNull("clonePortalPage", clonePortalPage);
        Assertions.notNull("targetPortalPage", targetPortalPage);
        List<PortletConfiguration> pcsToClone = this.portletConfigurationManager.getByPortalPage(clonePortalPage.getId());
        for (PortletConfiguration pc : pcsToClone) {
            String key = this.getGadgetPermissionManager().extractModuleKey(pc.getGadgetURI().toASCIIString());
            if (key != null && !this.getGadgetPermissionManager().voteOn(key, owner).equals((Object)Vote.ALLOW)) continue;
            this.portletConfigurationManager.addGadget(targetPortalPage.getId(), pc.getColumn(), pc.getRow(), pc.getGadgetURI(), pc.getColor(), pc.getUserPrefs());
        }
    }

    GadgetPermissionManager getGadgetPermissionManager() {
        if (this.gadgetPermissionManager == null) {
            this.gadgetPermissionManager = ComponentManager.getComponentInstanceOfType(GadgetPermissionManager.class);
        }
        return this.gadgetPermissionManager;
    }

    private boolean isSharedWith(PortalPage entity, User user) {
        return this.shareManager.hasPermission(user, entity);
    }

    private Collection<PortalPage> setRelatedState(Collection<PortalPage> portalPages) {
        ArrayList<PortalPage> ret = new ArrayList<PortalPage>(portalPages.size());
        for (PortalPage portalPage : portalPages) {
            ret.add(this.setRelatedState(portalPage));
        }
        return ret;
    }

    private PortalPage setRelatedState(PortalPage portalPage) {
        if (portalPage != null) {
            PortalPage.Builder builder = PortalPage.portalPage(portalPage);
            if (portalPage.isSystemDefaultPortalPage()) {
                builder.permissions(SharedEntity.SharePermissions.GLOBAL);
            } else {
                builder.permissions(this.shareManager.getSharePermissions(portalPage));
            }
            return builder.build();
        }
        return null;
    }

    private void assertCreate(PortalPage portalPage) {
        Assertions.notNull("portalPage", portalPage);
        if (!portalPage.isSystemDefaultPortalPage()) {
            Assertions.notNull("portalPage.owner.name", portalPage.getOwnerUserName());
        }
        Assertions.notNull("portalPage.pageName", portalPage.getName());
    }
}

