/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.LRUMap;
import com.atlassian.jira.util.dbc.Assertions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CachingPortalPageStore
implements PortalPageStore,
Startable {
    private final PortalPageStore delegateStore;
    private final Lock cacheLock = new ReentrantLock(false);
    private final Map<String, List<Long>> cacheByUser = LRUMap.newLRUMap(500);
    private final Map<Long, PortalPage> cacheById = LRUMap.newLRUMap(1000);
    private volatile Long systemDefaultPortalPageId = null;
    private final EventPublisher eventPublisher;

    public CachingPortalPageStore(PortalPageStore delegateStore, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        Assertions.notNull("delegateStore", delegateStore);
        this.delegateStore = delegateStore;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.flush();
    }

    @Override
    public EnclosedIterable<PortalPage> get(SharedEntityAccessor.RetrievalDescriptor ids) {
        return this.delegateStore.get(ids);
    }

    @Override
    public EnclosedIterable<PortalPage> getAll() {
        return this.delegateStore.getAll();
    }

    @Override
    public PortalPage getSystemDefaultPortalPage() {
        PortalPage page;
        if (this.systemDefaultPortalPageId == null && (page = this.delegateStore.getSystemDefaultPortalPage()) != null) {
            this.systemDefaultPortalPageId = page.getId();
        }
        if (this.systemDefaultPortalPageId != null) {
            return this.getPortalPage(this.systemDefaultPortalPageId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PortalPage> getAllOwnedPortalPages(User owner) {
        ArrayList<PortalPage> returnPages;
        Assertions.notNull("owner", owner);
        Assertions.notNull("owner.username", owner.getName());
        String ownerName = owner.getName();
        List<Long> ownedPageIds = null;
        this.cacheLock.lock();
        try {
            ownedPageIds = this.cacheByUser.get(ownerName);
        }
        finally {
            this.cacheLock.unlock();
        }
        if (ownedPageIds == null) {
            Collection<PortalPage> pagesFromDatabase = this.delegateStore.getAllOwnedPortalPages(owner);
            this.cacheLock.lock();
            try {
                if (pagesFromDatabase != null) {
                    ownedPageIds = new ArrayList<Long>(pagesFromDatabase.size());
                    returnPages = new ArrayList(pagesFromDatabase.size());
                    for (PortalPage portalPage : pagesFromDatabase) {
                        if (!this.cacheById.containsKey(portalPage.getId())) {
                            this.cacheById.put(portalPage.getId(), portalPage);
                        }
                        ownedPageIds.add(portalPage.getId());
                        returnPages.add(portalPage);
                    }
                    this.cacheByUser.put(ownerName, ownedPageIds);
                }
                returnPages = null;
            }
            finally {
                this.cacheLock.unlock();
            }
        } else {
            returnPages = new ArrayList<PortalPage>(ownedPageIds.size());
            for (Long id : ownedPageIds) {
                PortalPage portalPage = this.getPortalPage(id);
                if (portalPage == null) continue;
                returnPages.add(portalPage);
            }
        }
        return returnPages;
    }

    @Override
    public PortalPage getPortalPageByOwnerAndName(User owner, String portalPageName) {
        return this.delegateStore.getPortalPageByOwnerAndName(owner, portalPageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortalPage getPortalPage(Long portalPageId) {
        PortalPage portalPage;
        Assertions.notNull("portalPageId", portalPageId);
        this.cacheLock.lock();
        try {
            portalPage = this.cacheById.get(portalPageId);
        }
        finally {
            this.cacheLock.unlock();
        }
        if (portalPage == null && (portalPage = this.delegateStore.getPortalPage(portalPageId)) != null) {
            this.cacheLock.lock();
            try {
                this.cacheById.put(portalPage.getId(), portalPage);
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return portalPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="This appears to be doing exactly the right thing with the finally-clause to release the lock")
    public PortalPage create(PortalPage portalPage) {
        Assertions.notNull("portalPage", portalPage);
        Assertions.notNull("portalPage.name", portalPage.getName());
        Assertions.notNull("portalPage.ownerusername", portalPage.getOwnerUserName());
        PortalPage returnPage = null;
        try {
            returnPage = this.delegateStore.create(portalPage);
        }
        finally {
            if (returnPage != null) {
                this.cacheLock.lock();
                try {
                    this.cacheByUser.remove(portalPage.getOwnerUserName());
                    this.cacheById.put(returnPage.getId(), returnPage);
                }
                finally {
                    this.cacheLock.unlock();
                }
            }
        }
        return returnPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortalPage update(PortalPage portalPage) {
        Assertions.notNull("portalPage", portalPage);
        Assertions.notNull("portalPage.id", portalPage.getId());
        String newOwnerUserName = portalPage.getOwnerUserName();
        if (!portalPage.isSystemDefaultPortalPage()) {
            Assertions.notNull("portalPage.ownerusername", newOwnerUserName);
        }
        PortalPage returnPage = null;
        try {
            returnPage = this.delegateStore.update(portalPage);
        }
        finally {
            this.cacheLock.lock();
            try {
                if (returnPage != null) {
                    String oldOwnerUserName;
                    if (!portalPage.isSystemDefaultPortalPage() && !newOwnerUserName.equals(oldOwnerUserName = this.cacheById.get(returnPage.getId()).getOwnerUserName())) {
                        this.cacheByUser.remove(oldOwnerUserName);
                        this.cacheByUser.remove(newOwnerUserName);
                    }
                    this.cacheById.put(returnPage.getId(), returnPage);
                } else {
                    this.cacheById.remove(portalPage.getId());
                    if (!portalPage.isSystemDefaultPortalPage()) {
                        this.cacheByUser.remove(portalPage.getOwnerUserName());
                    }
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return returnPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePortalPageOptimisticLock(Long portalPageId, Long currentVersion) {
        Assertions.notNull("portalPageId", portalPageId);
        Assertions.notNull("currentVersion", currentVersion);
        try {
            boolean bl = this.delegateStore.updatePortalPageOptimisticLock(portalPageId, currentVersion);
            return bl;
        }
        finally {
            this.cacheLock.lock();
            try {
                this.cacheById.remove(portalPageId);
            }
            finally {
                this.cacheLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortalPage adjustFavouriteCount(SharedEntity portalPage, int incrementValue) {
        Assertions.notNull("portalPage", portalPage);
        Assertions.notNull("portalPage.id", portalPage.getId());
        PortalPage returnPage = null;
        try {
            returnPage = this.delegateStore.adjustFavouriteCount(portalPage, incrementValue);
        }
        finally {
            this.cacheLock.lock();
            try {
                if (returnPage != null) {
                    this.cacheById.put(returnPage.getId(), returnPage);
                } else {
                    this.cacheById.remove(portalPage.getId());
                    if (portalPage.getOwnerUserName() != null) {
                        this.cacheByUser.remove(portalPage.getOwnerUserName());
                    }
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return returnPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Long portalPageId) {
        Assertions.notNull("portalPageId", portalPageId);
        try {
            this.delegateStore.delete(portalPageId);
        }
        finally {
            this.cacheLock.lock();
            try {
                for (List<Long> ids : this.cacheByUser.values()) {
                    ids.remove(portalPageId);
                }
                this.cacheById.remove(portalPageId);
            }
            finally {
                this.cacheLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.cacheLock.lock();
        try {
            this.cacheById.clear();
            this.cacheByUser.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }
}

