/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPermissionPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginConditionFactory;
import com.atlassian.jira.security.Permissions;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import java.util.Map;

public class WorkflowPermissionConditionFactoryImpl
extends AbstractWorkflowPermissionPluginFactory
implements WorkflowPluginConditionFactory {
    private final SchemePermissions schemePermissions;

    public WorkflowPermissionConditionFactoryImpl(SchemePermissions schemePermissions) {
        super(schemePermissions);
        this.schemePermissions = schemePermissions;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        velocityParams.put("permission", this.getPermissionId(descriptor));
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        velocityParams.put("permission", this.schemePermissions.getPermissionName(this.getPermissionId(descriptor)));
    }

    public Map getDescriptorParams(Map conditionParams) {
        String value = this.extractSingleParam(conditionParams, "permission");
        int permissionId = Integer.parseInt(value);
        return EasyMap.build((Object)"permission", (Object)Permissions.getShortName(permissionId));
    }

    private Integer getPermissionId(AbstractDescriptor descriptor) {
        if (!(descriptor instanceof ConditionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ConditionDescriptor.");
        }
        ConditionDescriptor conditionDescriptor = (ConditionDescriptor)descriptor;
        String shortName = (String)conditionDescriptor.getArgs().get("permission");
        int permissionId = Permissions.getType(shortName);
        return new Integer(permissionId);
    }
}

