/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginConditionFactory;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class WorkflowIsUserInProjectRoleConditionFactoryImpl
extends AbstractWorkflowPluginFactory
implements WorkflowPluginConditionFactory {
    protected void getVelocityParamsForInput(Map velocityParams) {
        ListOrderedMap projectRoleMap = new ListOrderedMap();
        ProjectRoleManager projectRoleManager = ComponentManager.getComponentInstanceOfType(ProjectRoleManager.class);
        Collection<ProjectRole> projectRoles = projectRoleManager.getProjectRoles();
        for (ProjectRole projectRole : projectRoles) {
            projectRoleMap.put(projectRole.getId().toString(), projectRole.getName());
        }
        velocityParams.put("key", "jira.projectrole.id");
        velocityParams.put("projectroles", projectRoleMap);
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        if (!(descriptor instanceof ConditionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ConditionDescriptor.");
        }
        ConditionDescriptor conditionDescriptor = (ConditionDescriptor)descriptor;
        ProjectRoleManager projectRoleManager = ComponentManager.getComponentInstanceOfType(ProjectRoleManager.class);
        String id = (String)conditionDescriptor.getArgs().get("jira.projectrole.id");
        ProjectRole projectRole = projectRoleManager.getProjectRole(new Long(id));
        velocityParams.put("projectrole", id);
        if (projectRole != null) {
            velocityParams.put("projectrolename", projectRole.getName());
        }
    }

    public Map getDescriptorParams(Map conditionParams) {
        String value = this.extractSingleParam(conditionParams, "jira.projectrole.id");
        return EasyMap.build((Object)"jira.projectrole.id", (Object)value);
    }
}

