/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webwork;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.velocity.VelocityManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import webwork.view.velocity.VelocityHelper;

public class JiraPluginWebworkVelocityServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ActionContextKit.setContext(httpServletRequest, httpServletResponse, this.getServletContext());
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        if (servletPath != null && servletPath.indexOf("/") == 0) {
            servletPath = servletPath.substring(1);
        }
        ApplicationProperties applicationProperties = ComponentManager.getComponent(ApplicationProperties.class);
        Map<String, Object> velocityParams = JiraVelocityUtils.getDefaultVelocityParams(ComponentAccessor.getJiraAuthenticationContext());
        velocityParams.put("i18n", ComponentAccessor.getJiraAuthenticationContext().getI18nHelper());
        Context context = VelocityHelper.getContextWithoutInit((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, velocityParams);
        PrintWriter writer = httpServletResponse.getWriter();
        try {
            httpServletResponse.setContentType(applicationProperties.getContentType());
            VelocityManager velocityManager = ComponentAccessor.getVelocityManager();
            String body = velocityManager.getEncodedBody("", servletPath, null, applicationProperties.getEncoding(), context);
            writer.write(body);
        }
        catch (VelocityException e) {
            writer.write("Exception rendering velocity file " + servletPath);
            writer.write("<br><pre>");
            e.printStackTrace(writer);
            writer.write("</pre>");
        }
    }
}

