/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.contextproviders;

import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiContextProvider
implements ContextProvider {
    private final List<ContextProvider> ctxProviders = new ArrayList<ContextProvider>();
    private final PluginAccessor pluginAccessor;
    private final WebFragmentHelper webFragmentHelper;

    public MultiContextProvider(PluginAccessor pluginAccessor, WebFragmentHelper webFragmentHelper) {
        this.pluginAccessor = pluginAccessor;
        this.webFragmentHelper = webFragmentHelper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String pluginKey = params.get("pluginKey");
        if (pluginKey == null) {
            throw new PluginParseException("The pluginKey parameter must be specified.");
        }
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            throw new PluginParseException("Could not locate plugin with key \"" + pluginKey + "\".");
        }
        int classIndex = 1;
        while (params.containsKey("ctxProvider-" + classIndex)) {
            ContextProvider contextProvider;
            String classKey = "ctxProvider-" + classIndex;
            String className = params.get(classKey);
            try {
                contextProvider = this.webFragmentHelper.loadContextProvider(className, plugin);
            }
            catch (ConditionLoadingException exception) {
                throw new PluginParseException("Could not locate ContextProvider implementation named \"" + className + "\".", (Throwable)exception);
            }
            MapBuilder<String, String> subParamBuilder = MapBuilder.newBuilder();
            Set<Map.Entry<String, String>> allParams = params.entrySet();
            for (Map.Entry<String, String> paramEntry : allParams) {
                String key = paramEntry.getKey();
                if (!key.startsWith(classKey + ":")) continue;
                subParamBuilder.add(key.substring(key.indexOf(":") + 1), paramEntry.getValue());
            }
            contextProvider.init(subParamBuilder.toMap());
            this.ctxProviders.add(contextProvider);
            ++classIndex;
        }
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Map<String, Object> returnContext = MapBuilder.newBuilder(context).toMutableMap();
        for (ContextProvider provider : this.ctxProviders) {
            returnContext = CompositeMap.of(returnContext, provider.getContextMap(context));
        }
        return returnContext;
    }

    public List<ContextProvider> getCtxProviders() {
        return this.ctxProviders;
    }
}

