/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.contextproviders;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.util.Map;

public class ModifierKeyContextProvider
implements ContextProvider {
    private final JiraAuthenticationContext authenticationContext;

    public ModifierKeyContextProvider(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        MapBuilder<String, Object> paramsBuilder = MapBuilder.newBuilder(context);
        String modifierKey = BrowserUtils.getModifierKey();
        paramsBuilder.add("modifierKey", modifierKey);
        String submitAccessKey = i18n.getText("AUI.form.submit.button.accesskey");
        paramsBuilder.add("submitAccessKey", submitAccessKey);
        paramsBuilder.add("submitTitle", i18n.getText("AUI.form.submit.button.tooltip", submitAccessKey, modifierKey));
        String cancelAccessKey = i18n.getText("AUI.form.cancel.link.accesskey");
        paramsBuilder.add("cancelAccessKey", cancelAccessKey);
        paramsBuilder.add("cancelTitle", i18n.getText("AUI.form.cancel.link.tooltip", cancelAccessKey, modifierKey));
        return paramsBuilder.toMap();
    }
}

