/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.versionpanel;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.query.Query;
import java.util.Map;

public class BrowseVersionContextImpl
extends BrowseProjectContext
implements BrowseVersionContext {
    private final Version version;

    public BrowseVersionContextImpl(Version version, User user) {
        super(user, version.getProjectObject());
        this.version = version;
    }

    @Override
    public String getQueryString() {
        Query query = JqlQueryBuilder.newBuilder().where().fixVersion().eq(this.version.getName()).and().addClause(this.getProjectClause()).buildQuery();
        return this.getSearchService().getQueryString(this.getUser(), query);
    }

    @Override
    public Map<String, Object> createParameterMap() {
        Map<String, Object> map = super.createParameterMap();
        map.put("version", this.getVersion());
        return map;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Query createQuery() {
        Query superQuery = super.createQuery();
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder(superQuery);
        builder.where().defaultAnd().fixVersion().eq(this.version.getName());
        return builder.buildQuery();
    }

    @Override
    public String getContextKey() {
        return super.getContextKey() + "_version" + this.version.getId();
    }
}

