/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.util;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.Resources;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang.builder.ToStringBuilder;

public class InvolvedPluginsTracker {
    private final Set<PluginInfo> pluginsInvolved = new CopyOnWriteArraySet<PluginInfo>();

    private PluginInfo toInfo(Plugin plugin) {
        return new PluginInfo(plugin.getKey(), plugin.getPluginInformation().getVersion());
    }

    public void trackInvolvedPlugin(Plugin plugin) {
        this.pluginsInvolved.add(this.toInfo(Assertions.notNull("plugin", plugin)));
    }

    public void trackInvolvedPlugin(ModuleDescriptor moduleDescriptor) {
        this.pluginsInvolved.add(this.toInfo(Assertions.notNull("moduleDescriptor", moduleDescriptor).getPlugin()));
    }

    public boolean isPluginInvolved(Plugin plugin) {
        return this.pluginsInvolved.contains(this.toInfo(Assertions.notNull("plugin", plugin)));
    }

    public boolean isPluginInvolved(ModuleDescriptor moduleDescriptor) {
        return this.pluginsInvolved.contains(this.toInfo(Assertions.notNull("moduleDescriptor", moduleDescriptor).getPlugin()));
    }

    public boolean isPluginWithModuleDescriptor(ModuleDescriptor moduleDescriptor, Class<? extends ModuleDescriptor> targetModuleClass) {
        return this.isPluginWithModuleDescriptor(Assertions.notNull("moduleDescriptor", moduleDescriptor).getPlugin(), targetModuleClass);
    }

    public boolean isPluginWithModuleDescriptor(Plugin plugin, Class<? extends ModuleDescriptor> targetModuleClass) {
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            Class<?> moduleClass = moduleDescriptor.getClass();
            if (!targetModuleClass.isAssignableFrom(moduleClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isPluginWithResourceType(Plugin plugin, String pluginResourceType) {
        ArrayList locations = new ArrayList();
        Iterables.addAll(locations, (Iterable)Iterables.filter((Iterable)plugin.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(pluginResourceType)));
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            Iterables.addAll(locations, (Iterable)Iterables.filter((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(pluginResourceType)));
        }
        return !locations.isEmpty();
    }

    public boolean isPluginWithResourceType(ModuleDescriptor moduleDescriptor, String pluginResourceType) {
        return this.isPluginWithResourceType(Assertions.notNull("moduleDescriptor", moduleDescriptor).getPlugin(), pluginResourceType);
    }

    public Set<PluginInfo> getInvolvedPluginKeys() {
        return Sets.newLinkedHashSet(this.pluginsInvolved);
    }

    public void clear() {
        this.pluginsInvolved.clear();
    }

    public int hashCode() {
        return ((Object)this.pluginsInvolved).hashCode();
    }

    public String toString() {
        return super.toString() + " " + this.pluginsInvolved.toString();
    }

    public static class PluginInfo
    implements Comparable<PluginInfo> {
        private final String pluginKey;
        private final String pluginVersion;

        public PluginInfo(String pluginKey, String pluginVersion) {
            this.pluginKey = Assertions.notNull("pluginKey", pluginKey);
            this.pluginVersion = Assertions.notNull("pluginVersion", pluginVersion);
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        @Override
        public int compareTo(PluginInfo that) {
            int rc = this.pluginKey.compareTo(that.pluginKey);
            if (rc == 0) {
                rc = this.pluginVersion.compareTo(that.pluginVersion);
            }
            return rc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginInfo that = (PluginInfo)o;
            return this.pluginKey.equals(that.pluginKey) && this.pluginVersion.equals(that.pluginVersion);
        }

        public int hashCode() {
            int result = this.pluginKey.hashCode();
            result = 31 * result + this.pluginVersion.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

