/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat.configuration;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.userformat.configuration.UserFormatTypeConfiguration;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;

public class PropertySetBackedUserFormatTypeConfiguration
implements UserFormatTypeConfiguration,
Startable {
    static final String USER_FORMAT_CONFIGURATION_PROPERTY_SET_KEY = "user.format.mapping";
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<PropertySet> mappingPSRef;

    public PropertySetBackedUserFormatTypeConfiguration(final JiraPropertySetFactory jiraPropertySetFactory, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.mappingPSRef = new ResettableLazyReference<PropertySet>(){

            protected PropertySet create() throws Exception {
                return jiraPropertySetFactory.buildCachingDefaultPropertySet(PropertySetBackedUserFormatTypeConfiguration.USER_FORMAT_CONFIGURATION_PROPERTY_SET_KEY, true);
            }
        };
    }

    @Override
    public void start() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.mappingPSRef.reset();
    }

    @Override
    public void setUserFormatKeyForType(String userFormatType, String moduleKey) {
        ((PropertySet)this.mappingPSRef.get()).setString(userFormatType, moduleKey);
    }

    @Override
    public String getUserFormatKeyForType(String userFormatType) {
        return ((PropertySet)this.mappingPSRef.get()).getString(userFormatType);
    }

    @Override
    public boolean containsType(String userFormatType) {
        return ((PropertySet)this.mappingPSRef.get()).getString(userFormatType) != null;
    }

    @Override
    public void remove(String userFormatType) {
        ((PropertySet)this.mappingPSRef.get()).remove(userFormatType);
    }

    Collection<String> getConfiguredTypes() {
        return ((PropertySet)this.mappingPSRef.get()).getKeys();
    }
}

