/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat.configuration;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.userformat.configuration.PropertySetBackedUserFormatTypeConfiguration;
import com.atlassian.jira.plugin.userformat.configuration.UserFormatTypeConfiguration;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.google.common.collect.Iterables;

public class PluginsAwareUserFormatTypeConfiguration
implements UserFormatTypeConfiguration,
Startable {
    private final EventPublisher eventPublisher;
    private final PropertySetBackedUserFormatTypeConfiguration delegate;

    public PluginsAwareUserFormatTypeConfiguration(EventPublisher eventPublisher, JiraPropertySetFactory jiraPropertySetFactory) {
        this.eventPublisher = eventPublisher;
        this.delegate = new PropertySetBackedUserFormatTypeConfiguration(jiraPropertySetFactory, eventPublisher);
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @PluginEventListener
    public void onPluginUninstalled(PluginUninstalledEvent event) {
        Iterable userFormatModuleDescriptors = Iterables.filter((Iterable)event.getPlugin().getModuleDescriptors(), UserFormatModuleDescriptor.class);
        if (Iterables.size((Iterable)userFormatModuleDescriptors) > 0) {
            for (UserFormatModuleDescriptor descriptor : userFormatModuleDescriptors) {
                this.removeUserFormatFrom(descriptor);
            }
        }
    }

    private void removeUserFormatFrom(UserFormatModuleDescriptor descriptor) {
        for (String userFormatType : this.delegate.getConfiguredTypes()) {
            if (!this.getUserFormatKeyForType(userFormatType).equals(descriptor.getCompleteKey())) continue;
            this.remove(userFormatType);
            break;
        }
    }

    @Override
    public boolean containsType(String userFormatType) {
        return this.delegate.containsType(userFormatType);
    }

    @Override
    public void setUserFormatKeyForType(String userFormatType, String moduleKey) {
        this.delegate.setUserFormatKeyForType(userFormatType, moduleKey);
    }

    @Override
    public String getUserFormatKeyForType(String userFormatType) {
        return this.delegate.getUserFormatKeyForType(userFormatType);
    }

    @Override
    public void remove(String userFormatType) {
        this.delegate.remove(userFormatType);
    }
}

