/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;

public class ProfileLinkUserFormat
implements UserFormat {
    public static final String TYPE = "profileLink";
    private final UserFormatModuleDescriptor moduleDescriptor;
    private final UserUtil userUtil;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public ProfileLinkUserFormat(UserFormatModuleDescriptor moduleDescriptor, UserUtil userUtil, AvatarService avatarService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.moduleDescriptor = moduleDescriptor;
        this.userUtil = userUtil;
        this.avatarService = avatarService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String format(String username, String id) {
        Map<String, Object> params = this.getInitialParams(username, id);
        return this.moduleDescriptor.getHtml("view", params);
    }

    @Override
    public String format(String username, String id, Map<String, Object> params) {
        Map<String, Object> velocityParams = this.getInitialParams(username, id);
        velocityParams.putAll(params);
        return this.moduleDescriptor.getHtml("view", velocityParams);
    }

    private Map<String, Object> getInitialParams(String username, String id) {
        User user = this.userUtil.getUserObject(username);
        String fullName = user == null ? username : this.userUtil.getDisplayableNameSafely(user);
        String avatarURL = this.avatarService.getAvatarURL(this.jiraAuthenticationContext.getLoggedInUser(), username, Avatar.Size.SMALL).toString();
        return MapBuilder.newBuilder().add("username", username).add("user", (String)user).add("fullname", fullName).add("id", id).add("avatarURL", avatarURL).toMutableMap();
    }
}

