/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.component.webfragment.ViewUserProfileContextLayoutBean;
import com.atlassian.jira.web.component.webfragment.WebFragmentWebComponent;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class FullProfileUserFormat
implements UserFormat {
    private final EmailFormatter emailFormatter;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final GroupPermissionChecker groupPermissionChecker;
    private final WebFragmentWebComponent webFragmentWebComponent;
    private final UserUtil userUtil;
    private final UserFormatModuleDescriptor moduleDescriptor;
    private final UserPropertyManager userPropertyManager;
    private final GroupManager groupManager;

    public FullProfileUserFormat(EmailFormatter emailFormatter, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, GroupPermissionChecker groupPermissionChecker, WebFragmentWebComponent webFragmentWebComponent, UserUtil userUtil, UserFormatModuleDescriptor moduleDescriptor, UserPropertyManager userPropertyManager, GroupManager groupManager) {
        this.emailFormatter = emailFormatter;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.groupPermissionChecker = groupPermissionChecker;
        this.webFragmentWebComponent = webFragmentWebComponent;
        this.userUtil = userUtil;
        this.moduleDescriptor = moduleDescriptor;
        this.userPropertyManager = userPropertyManager;
        this.groupManager = groupManager;
    }

    @Override
    public String format(String username, String id) {
        Map<String, String> params = MapBuilder.newBuilder().add("username", username).add("user", (String)this.userUtil.getUserObject(username)).add("action", (String)((Object)this)).add("navWebFragment", (String)((Object)this.webFragmentWebComponent)).add("id", id).toMap();
        return this.moduleDescriptor.getHtml("view", params);
    }

    public String format(String username, String id, Map params) {
        return this.format(username, id);
    }

    public boolean isUserLoggedinUser(User user) {
        return user.equals(this.authenticationContext.getLoggedInUser());
    }

    public boolean isEmailVisible(User user) {
        return this.emailFormatter.emailVisible(user);
    }

    public String getDisplayEmail(User user) {
        return this.emailFormatter.formatEmailAsLink(user.getEmailAddress(), user);
    }

    public boolean hasViewGroupPermission(String group) {
        return this.groupPermissionChecker.hasViewGroupPermission(group, this.authenticationContext.getLoggedInUser());
    }

    public String getUserLinks(User profileUser, String template) {
        HttpServletRequest servletRequest = ActionContext.getRequest();
        ViewUserProfileContextLayoutBean userNavLayout = new ViewUserProfileContextLayoutBean(profileUser, (String)ActionContext.getValueStack().findValue("/actionName"));
        servletRequest.setAttribute("profileUser", (Object)profileUser);
        Map<String, User> params = MapBuilder.build("profileUser", profileUser);
        JiraHelper helper = new JiraHelper(servletRequest, null, params);
        return this.webFragmentWebComponent.getHtml(template, "system.user.profile.links", helper, userNavLayout);
    }

    public Map getUserProperties(User user) {
        HashMap userProperties = Maps.newHashMap();
        if (user != null && this.isHasPermission(0)) {
            PropertySet userPropertySet = this.userPropertyManager.getPropertySet(user);
            for (Object userPropertyKeyAsObject : userPropertySet.getKeys(5)) {
                String userPropertyKeyAsString = (String)userPropertyKeyAsObject;
                if (!userPropertyKeyAsString.startsWith("jira.meta.")) continue;
                userProperties.put(userPropertyKeyAsString.substring("jira.meta.".length()), userPropertySet.getString(userPropertyKeyAsString));
            }
        }
        return userProperties;
    }

    public boolean isHasPermission(int permissionsId) {
        return this.permissionManager.hasPermission(permissionsId, this.authenticationContext.getLoggedInUser());
    }

    public List<String> getGroupNames(User user) {
        String username;
        String string = username = user == null ? null : user.getName();
        if (username == null) {
            return Collections.emptyList();
        }
        Collection<Group> groups = this.groupManager.getGroupsForUser(username);
        ArrayList<String> groupNames = new ArrayList<String>(groups.size());
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }
}

