/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.roles;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import org.dom4j.Element;

public class ProjectRoleActorModuleDescriptor
extends AbstractJiraModuleDescriptor<RoleActorFactory> {
    public static final String TEMPLATE_NAME_CONFIGURE = "configure";
    private static final String ROLEACTOR_TYPE = "roleactor.type";
    private static final String PRETTYNAME_KEY = "prettyname.key";

    public ProjectRoleActorModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.assertConfigurationParameterPresent(PRETTYNAME_KEY);
        this.assertConfigurationParameterPresent(ROLEACTOR_TYPE);
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(RoleActorFactory.class);
    }

    public boolean isRoleActorConfigurationTemplateExists() {
        return this.isResourceExist(TEMPLATE_NAME_CONFIGURE);
    }

    public String getType() {
        return (String)this.getParams().get(ROLEACTOR_TYPE);
    }

    public String getConfigurationUrl() {
        return (String)this.getParams().get("ConfigurationURL");
    }

    public String getPrettyName() {
        return this.getText((String)this.getParams().get(PRETTYNAME_KEY), null);
    }

    private void assertConfigurationParameterPresent(String paramKey) throws PluginParseException {
        if (this.getParams().get(paramKey) == null) {
            throw new PluginParseException(this.getClass() + " plugins must be configured with a '" + paramKey + "' parameter");
        }
    }
}

