/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class UserSubTaskIncludeValuesGenerator
implements ValuesGenerator {
    @Override
    public Map getValues(Map userParams) {
        User u = (User)userParams.get("User");
        I18nBean i18nHelper = new I18nBean(u);
        ListOrderedMap result = new ListOrderedMap();
        result.put("onlyAssigned", Options.getDescription("onlyAssigned", i18nHelper));
        result.put("assignedAndUnassigned", Options.getDescription("assignedAndUnassigned", i18nHelper));
        return Collections.unmodifiableMap(result);
    }

    static final class Options {
        static final String ONLY_ASSIGNED = "onlyAssigned";
        static final String ASSIGNED_AND_UNASSIGNED = "assignedAndUnassigned";

        Options() {
        }

        static String getDescription(String option, I18nHelper i18nHelper) {
            if (ONLY_ASSIGNED.equals(option)) {
                return i18nHelper.getText("report.subtasks.user.include.selected.only");
            }
            if (ASSIGNED_AND_UNASSIGNED.equals(option)) {
                return i18nHelper.getText("report.subtasks.user.include.selected.and.unassigned");
            }
            return "Unknown option: " + option;
        }
    }
}

