/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class SubTaskIncludeValuesGenerator
implements ValuesGenerator {
    @Override
    public Map getValues(Map userParams) {
        User u = (User)userParams.get("User");
        I18nBean i18nHelper = new I18nBean(u);
        ListOrderedMap result = new ListOrderedMap();
        result.put("onlySelected", Options.getDescription("onlySelected", i18nHelper));
        result.put("selectedAndBlank", Options.getDescription("selectedAndBlank", i18nHelper));
        result.put("all", Options.getDescription("all", i18nHelper));
        return Collections.unmodifiableMap(result);
    }

    static final class Options {
        static final String ONLY_SELECTED = "onlySelected";
        static final String SELECTED_AND_BLANK = "selectedAndBlank";
        static final String ALL = "all";

        Options() {
        }

        static String getDescription(String option, I18nHelper i18nHelper) {
            if (ONLY_SELECTED.equals(option)) {
                return i18nHelper.getText("report.subtasks.include.selected.only");
            }
            if (SELECTED_AND_BLANK.equals(option)) {
                return i18nHelper.getText("report.subtasks.include.selected.none");
            }
            if (ALL.equals(option)) {
                return i18nHelper.getText("report.subtasks.include.all");
            }
            return "Unknown option: " + option;
        }
    }
}

