/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.report.impl.AbstractReport;
import com.atlassian.jira.plugin.report.impl.SubTaskFetcher;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.bean.PagerFilter;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeveloperWorkloadReport
extends AbstractReport {
    private final Logger log = Logger.getLogger(DeveloperWorkloadReport.class);
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final JiraDurationUtils jiraDurationUtils;
    private final SearchProvider searchProvider;

    public DeveloperWorkloadReport(ProjectManager projectManager, ApplicationProperties applicationProperties, JiraDurationUtils jiraDurationUtils) {
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
        this.jiraDurationUtils = jiraDurationUtils;
        this.searchProvider = ComponentManager.getInstance().getSearchProvider();
    }

    @Override
    public boolean showReport() {
        return this.applicationProperties.getOption("jira.option.timetracking");
    }

    @Override
    public void validate(ProjectActionSupport action, Map params) {
        super.validate(action, params);
        String developer = (String)params.get("developer");
        if (!TextUtils.stringSet((String)developer)) {
            action.addError("developer", action.getText("report.developerworkload.developer.is.required"));
        } else if (!UserUtils.userExists(developer)) {
            action.addError("developer", action.getText("report.developerworkload.developer.does.not.exist"));
        }
    }

    @Override
    public String generateReportHtml(ProjectActionSupport action, Map reqParams) throws Exception {
        User remoteUser = action.getLoggedInUser();
        User developer = UserUtils.getUser((String)reqParams.get("developer"));
        String subtaskInclusion = (String)reqParams.get("subtaskInclusion");
        if (subtaskInclusion == null) {
            subtaskInclusion = "onlyAssigned";
        }
        ArrayList<Issue> result = new ArrayList<Issue>();
        List<Issue> assignedIssues = this.initAssignedIssues(remoteUser, developer);
        result.addAll(assignedIssues);
        List<Issue> subTasks = new SubTaskFetcher(this.searchProvider).getSubTasksForUser(remoteUser, result, subtaskInclusion, true);
        result.addAll(subTasks);
        Map countMap = this.initCountMap(result);
        Map workloadMap = this.initWorkloadMap(result);
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("report", this);
        velocityParams.put("action", action);
        velocityParams.put("developer", developer);
        velocityParams.put("assignedIssues", result);
        velocityParams.put("countMap", countMap);
        velocityParams.put("workloadMap", workloadMap);
        velocityParams.put("totalCount", this.getTotalIssuesCount(countMap));
        velocityParams.put("totalWorkload", this.getTotalWorkload(workloadMap));
        return this.descriptor.getHtml("view", velocityParams);
    }

    public String formatPrettyDuration(Long v) {
        return this.jiraDurationUtils.getFormattedDuration(v, this.descriptor.getI18nBean().getLocale());
    }

    List<Issue> initAssignedIssues(User remoteUser, User developer) {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        builder.where().assigneeUser(developer.getName()).and().unresolved();
        try {
            SearchResults searchResults = this.searchProvider.search(builder.buildQuery(), remoteUser, PagerFilter.getUnlimitedFilter());
            return searchResults.getIssues();
        }
        catch (SearchException e) {
            this.log.error((Object)("Error executing Search Request in DeveloperWorkloadReport (remoteUser=" + remoteUser + ", developer=" + developer + "): " + e), (Throwable)e);
            return Collections.emptyList();
        }
    }

    Map initCountMap(List<Issue> assignedIssues) {
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        for (Issue assignedIssue : assignedIssues) {
            Long estimate = assignedIssue.getEstimate();
            if (estimate == null) continue;
            String pid = String.valueOf(assignedIssue.getProjectObject().getId());
            if (countMap.containsKey(pid)) {
                long current = (Long)countMap.get(pid);
                countMap.put(pid, new Long(current + 1L));
                continue;
            }
            countMap.put(pid, new Long(1L));
        }
        return countMap;
    }

    Map initWorkloadMap(List<Issue> assignedIssues) {
        HashMap<String, Long> workloadMap = new HashMap<String, Long>();
        for (Issue assignedIssue : assignedIssues) {
            String pid = String.valueOf(assignedIssue.getProjectObject().getId());
            Long estimate = assignedIssue.getEstimate();
            if (estimate == null) continue;
            if (workloadMap.containsKey(pid)) {
                long currentEstimate = (Long)workloadMap.get(pid);
                workloadMap.put(pid, new Long(currentEstimate + estimate));
                continue;
            }
            workloadMap.put(pid, estimate);
        }
        return workloadMap;
    }

    public Long getTotalIssuesCount(Map countMap) {
        long total = 0L;
        for (Long count : countMap.values()) {
            total += count.longValue();
        }
        return new Long(total);
    }

    public Long getTotalWorkload(Map workloadMap) {
        long totalWorkload = 0L;
        for (Long workload : workloadMap.values()) {
            totalWorkload += workload.longValue();
        }
        return new Long(totalWorkload);
    }

    public String getProjectName(String pid) {
        return this.projectManager.getProjectObj(new Long(pid)).getName();
    }
}

