/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.impl;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.plugin.util.TabPanelUtil;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.List;
import java.util.Map;

public class PopularIssuesProjectTabPanel
extends AbstractProjectTabPanel {
    private final ApplicationProperties applicationProperties;
    private final SearchProvider searchProvider;
    private final ConstantsManager constantsManager;
    private final FieldVisibilityManager fieldVisibilityManager;

    public PopularIssuesProjectTabPanel(ApplicationProperties applicationProperties, SearchProvider searchProvider, ConstantsManager constantsManager, JiraAuthenticationContext authenticationContext, FieldVisibilityManager fieldVisibilityManager) {
        super(authenticationContext);
        this.applicationProperties = applicationProperties;
        this.searchProvider = searchProvider;
        this.constantsManager = constantsManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> params = super.createVelocityParams(ctx);
        params.put("popularIssues", this.getPopularIssues(ctx));
        params.put("fieldVisibility", this.fieldVisibilityManager);
        return params;
    }

    @Override
    public boolean showPanel(BrowseContext ctx) {
        return this.applicationProperties.getOption("jira.option.voting");
    }

    private List getPopularIssues(BrowseContext ctx) {
        TabPanelUtil.PopularIssues popularIssues = new TabPanelUtil.PopularIssues(this.searchProvider, this.constantsManager);
        return popularIssues.getIssues(ctx, false);
    }
}

