/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.impl;

import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.google.common.collect.Maps;
import java.util.HashMap;

public class ComponentsVersionsProjectTabPanel
extends AbstractProjectTabPanel {
    private final FieldVisibilityManager fieldVisibilityManager;

    public ComponentsVersionsProjectTabPanel(JiraAuthenticationContext authenticationContext, FieldVisibilityManager fieldVisibilityManager) {
        super(authenticationContext);
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    public String getHtml(BrowseContext ctx) {
        try {
            HashMap startingParams = Maps.newHashMap();
            startingParams.put("project", ctx.getProject());
            startingParams.put("fieldVisibility", this.fieldVisibilityManager);
            startingParams.put("i18n", this.authenticationContext.getI18nHelper());
            StatisticAccessorBean statisticAccessorBean = new StatisticAccessorBean(this.authenticationContext.getLoggedInUser(), ctx.getProject().getId());
            StatisticMapWrapper componentStats = statisticAccessorBean.getWrapper(new FilterStatisticsValuesGenerator().getStatsMapper("components"));
            StatisticMapWrapper versionStats = statisticAccessorBean.getWrapper(new FilterStatisticsValuesGenerator().getStatsMapper("allFixfor"));
            startingParams.put("componentStats", componentStats);
            startingParams.put("versionStats", versionStats);
            return this.descriptor.getHtml("view", startingParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean showPanel(BrowseContext ctx) {
        Long projectId = ctx.getProject().getId();
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(projectId, "fixVersions", null) || !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(projectId, "components", null);
    }
}

