/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractUnresolvedIssuesFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractUrlFragmentUtil;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;
import com.atlassian.velocity.VelocityManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnresolvedIssuesByPriorityFragment
extends AbstractUnresolvedIssuesFragment
implements ProjectTabPanelFragment {
    private static final Logger log = Logger.getLogger(UnresolvedIssuesByPriorityFragment.class);
    private final ConstantsManager constantsManager;

    public UnresolvedIssuesByPriorityFragment(VelocityManager velocityManager, ApplicationProperties applicationProperites, JiraAuthenticationContext jiraAuthenticationContext, ConstantsManager constantsManager) {
        super(velocityManager, applicationProperites, jiraAuthenticationContext);
        this.constantsManager = constantsManager;
    }

    @Override
    public String getId() {
        return "unresolvedissuesbypriority";
    }

    @Override
    String getIssueFieldConstant() {
        return "priority";
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("priorities", this.getPriorities(ctx));
        velocityParams.put("urlUtil", new PriorityUrlUtil(this.getSearchRequest(ctx), this.jiraAuthenticationContext.getLoggedInUser(), this.applicationProperites));
        return velocityParams;
    }

    StatisticMapWrapper getPriorities(BrowseContext ctx) {
        try {
            StatisticMapWrapper map = this.getStatsBean(ctx).getAllFilterBy("priorities");
            this.transformStatisticMapWrapper(map);
            return map;
        }
        catch (SearchException e) {
            log.error((Object)("Could not search for priorities in project '" + ctx.getProject().getKey() + "'"), (Throwable)e);
            return null;
        }
    }

    @Override
    void addSearchSorts(JqlQueryBuilder builder) {
        builder.orderBy().issueKey(SortOrder.DESC, true);
    }

    private void transformStatisticMapWrapper(StatisticMapWrapper map) {
        LinkedHashMap<Priority, Integer> priorityMap = new LinkedHashMap<Priority, Integer>(map.size());
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            Priority priority = (Priority)entry.getKey();
            priorityMap.put(priority, (Integer)entry.getValue());
        }
        map.setStatistics(priorityMap);
    }

    public static class PriorityUrlUtil
    extends AbstractUrlFragmentUtil<Priority> {
        public PriorityUrlUtil(SearchRequest searchRequest, User user, ApplicationProperties applicationProperties) {
            super(searchRequest, user, applicationProperties);
        }

        @Override
        protected Clause getDomainClause(Priority priority) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            builder.priority().eq(priority.getName());
            return builder.buildClause();
        }

        @Override
        protected OrderBy getOrderBy() {
            JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
            jqlOrderByBuilder.priority(SortOrder.DESC);
            return jqlOrderByBuilder.buildOrderBy();
        }
    }
}

