/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractMultiFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.FieldVisibilityBean;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.SortOrder;
import com.atlassian.velocity.VelocityManager;

abstract class AbstractUnresolvedIssuesFragment
extends AbstractMultiFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/projectpanels/fragments/issues/";

    public AbstractUnresolvedIssuesFragment(VelocityManager velocityManager, ApplicationProperties applicationProperites, JiraAuthenticationContext jiraAuthenticationContext) {
        super(velocityManager, applicationProperites, jiraAuthenticationContext);
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        FieldVisibilityBean fieldVisibilityManager = new FieldVisibilityBean();
        return !fieldVisibilityManager.isFieldHiddenInAllSchemes(ctx.getProject().getId(), this.getIssueFieldConstant());
    }

    abstract String getIssueFieldConstant();

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    StatisticAccessorBean getStatsBean(BrowseContext ctx) {
        SearchRequest filter = this.getSearchRequest(ctx);
        Clause whereClause = filter.getQuery().getWhereClause();
        filter.setQuery(new QueryImpl(whereClause, null, null));
        return new StatisticAccessorBean(ctx.getUser(), filter);
    }

    SearchRequest getSearchRequest(BrowseContext ctx) {
        Query initialQuery = ctx.createQuery();
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder(initialQuery);
        builder.where().defaultAnd().unresolved();
        this.addSearchSorts(builder);
        return new SearchRequest(builder.buildQuery());
    }

    void addSearchSorts(JqlQueryBuilder builder) {
        builder.orderBy().priority(SortOrder.DESC, true);
    }
}

