/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractMultiFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractIssuesFragment
extends AbstractMultiFragment {
    private static final Logger log = Logger.getLogger(AbstractIssuesFragment.class);
    protected static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/projectpanels/fragments/summary/";
    private static final Integer DEFAULT_DISPLAY_ISSUE_COUNT = 3;
    protected final SearchProvider searchProvider;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public AbstractIssuesFragment(JiraAuthenticationContext jiraAuthenticationContext, VelocityManager velocityManager, SearchProvider searchProvider, ApplicationProperties applicationProperites, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(velocityManager, applicationProperites, jiraAuthenticationContext);
        this.searchProvider = searchProvider;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("issues", this.getIssues(ctx));
        velocityParams.put("srUrl", this.createSearchRequestUrl(this.getSearchRequest(ctx)));
        velocityParams.put("relativeDateTimeFormatter", this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.RELATIVE_WITH_TIME_ONLY).forLoggedInUser());
        velocityParams.put("SFM_HIDE", (Object)OutlookDate.SmartFormatterModes.HIDE_TIME);
        return velocityParams;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return this.getDisplayIssueCount() > 0 && !this.getIssues(ctx).isEmpty();
    }

    Integer getDisplayIssueCount() {
        String displayIssueCount = this.applicationProperites.getDefaultBackedString("jira.project.summary.max.issues");
        try {
            if (displayIssueCount == null) {
                return DEFAULT_DISPLAY_ISSUE_COUNT;
            }
            Integer intDisplayIssueCount = Integer.valueOf(displayIssueCount);
            if (intDisplayIssueCount < 0) {
                return DEFAULT_DISPLAY_ISSUE_COUNT;
            }
            return intDisplayIssueCount;
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid value for application property 'jira.project.summary.max.issues': " + displayIssueCount));
            return DEFAULT_DISPLAY_ISSUE_COUNT;
        }
    }

    List<Issue> getIssues(BrowseContext ctx) {
        try {
            SearchRequest sr = this.getSearchRequest(ctx);
            PagerFilter pagerFilter = new PagerFilter(this.getDisplayIssueCount());
            SearchResults results = this.searchProvider.search(sr.getQuery(), this.jiraAuthenticationContext.getLoggedInUser(), pagerFilter);
            if (results != null && results.getIssues() != null) {
                return results.getIssues();
            }
        }
        catch (SearchException e) {
            log.warn((Object)"Could not complete the search request", (Throwable)e);
        }
        return new ArrayList<Issue>();
    }

    abstract SearchRequest getSearchRequest(BrowseContext var1);

    private String createSearchRequestUrl(SearchRequest sr) {
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperites).getJiraVelocityRequestContext();
        StringBuilder link = new StringBuilder();
        link.append(SearchRequestViewUtils.getLink(sr, velocityRequestContext.getBaseUrl(), this.jiraAuthenticationContext.getLoggedInUser())).append("&mode=hide");
        return link.toString();
    }
}

