/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.velocity.VelocityManager;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public abstract class AbstractFragment
implements ProjectTabPanelFragment {
    protected static final Logger log = Logger.getLogger(AbstractFragment.class);
    protected final VelocityManager velocityManager;
    protected final ApplicationProperties applicationProperites;
    protected final JiraAuthenticationContext jiraAuthenticationContext;

    protected AbstractFragment(VelocityManager velocityManager, ApplicationProperties applicationProperites, JiraAuthenticationContext jiraAuthenticationContext) {
        this.velocityManager = velocityManager;
        this.applicationProperites = applicationProperites;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    protected abstract String getTemplateDirectoryPath();

    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = JiraVelocityUtils.getDefaultVelocityParams(this.jiraAuthenticationContext);
        velocityParams.put("fragid", this.getId());
        velocityParams.put("i18n", this.jiraAuthenticationContext.getI18nHelper());
        velocityParams.put("browseContext", ctx);
        velocityParams.putAll(ctx.createParameterMap());
        return velocityParams;
    }

    @Override
    public String getHtml(BrowseContext ctx) {
        String template = this.getId() + ".vm";
        try {
            Map<String, Object> velocityParams = this.createVelocityParams(ctx);
            String encoding = this.applicationProperites.getEncoding();
            return this.velocityManager.getEncodedBody(this.getTemplateDirectoryPath(), template, encoding, velocityParams);
        }
        catch (VelocityException e) {
            log.error((Object)("Error occurred while rendering velocity template for '" + this.getTemplateDirectoryPath() + template + "'."), (Throwable)e);
            return "";
        }
    }
}

