/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.language;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.language.Language;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.opensymphony.util.TextUtils;
import org.dom4j.Element;

public class LanguageModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<Language>
implements LanguageModuleDescriptor {
    private String encoding;
    private String language;
    private String country;
    private String variant;

    public LanguageModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attribute("language") == null || !TextUtils.stringSet((String)element.attribute("language").getValue())) {
            throw new PluginParseException("Module " + this.getCompleteKey() + " must define a \"language\" attribute");
        }
        if (element.attribute("language") != null) {
            this.setLanguage(element.attribute("language").getText());
        }
        if (element.attribute("country") != null) {
            this.setCountry(element.attribute("country").getText());
        }
        if (element.attribute("variant") != null) {
            this.setVariant(element.attribute("variant").getText());
        }
        if (element.attribute("encoding") != null) {
            this.setEncoding(element.attribute("encoding").getText());
        }
    }

    @Override
    protected Language createModule() {
        return new Language(this);
    }

    @Override
    public String getResourceBundleName() {
        return DefaultResourceBundle.DEFAULT_RESOURCE_BUNDLE_NAME;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    @Override
    public void setVariant(String variant) {
        this.variant = variant;
    }
}

