/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.keyboardshortcut;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.OrderableModuleDescriptor;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcut;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class KeyboardShortcutModuleDescriptor
extends AbstractJiraModuleDescriptor<KeyboardShortcut>
implements OrderableModuleDescriptor {
    private static final Logger log = Logger.getLogger(KeyboardShortcutModuleDescriptor.class);
    private static final Pattern JSON_VALUE_STRING = Pattern.compile("^\".*\"$");
    private static final Pattern JSON_VALUE_ARRAY = Pattern.compile("^\\[.*\\]$");
    private final KeyboardShortcutManager keyboardShortcutManager;
    private KeyboardShortcutManager.Context context = KeyboardShortcutManager.Context.global;
    private KeyboardShortcutManager.Operation operation;
    private String operationParam;
    private Set<List<String>> shortcuts = new HashSet<List<String>>();
    private String descriptionKey;
    private int order;
    private boolean hidden = false;

    public KeyboardShortcutModuleDescriptor(JiraAuthenticationContext authenticationContext, KeyboardShortcutManager keyboardShortcutManager, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
        this.keyboardShortcutManager = keyboardShortcutManager;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        List<String> shortcutCombination;
        Element shortcutEl;
        Element contextEl;
        super.init(plugin, element);
        Attribute hiddenAttr = element.attribute("hidden");
        if (hiddenAttr != null && StringUtils.isNotEmpty((String)hiddenAttr.getText())) {
            this.hidden = Boolean.parseBoolean(hiddenAttr.getText());
        }
        if ((contextEl = element.element("context")) != null) {
            String contextString = StringUtils.trim((String)contextEl.getText());
            try {
                this.context = KeyboardShortcutManager.Context.valueOf(contextString);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Invalid keyboard shortcut context of '" + contextString + "' defined.  Falling back to global context!"));
                this.context = KeyboardShortcutManager.Context.global;
            }
        }
        if ((shortcutEl = element.element("shortcut")) != null) {
            try {
                shortcutCombination = KeyboardShortcutModuleDescriptor.parseShortcut(shortcutEl.getTextTrim());
            }
            catch (JSONException e) {
                throw new PluginParseException("The <shortcut> element did not provide a valid keyboard shortcut definition!");
            }
            if (shortcutCombination.isEmpty()) {
                throw new PluginParseException("The <shortcut> element did not provide a valid keyboard shortcut definition!");
            }
        } else {
            throw new PluginParseException("<shortcut> is a required element for a keyboard shortcut plugin module!");
        }
        this.shortcuts.add(shortcutCombination);
        Element operationEl = element.element("operation");
        if (operationEl != null) {
            String operationType = operationEl.attribute("type").getText();
            try {
                this.operation = KeyboardShortcutManager.Operation.valueOf(operationType);
            }
            catch (IllegalArgumentException e) {
                throw new PluginParseException("Invalid operation type '" + operationType + "' provided!");
            }
        } else {
            throw new PluginParseException("<operation> is a required element for a keyboard shortcut plugin module!");
        }
        this.operationParam = StringUtils.trim((String)operationEl.getText());
        this.order = ModuleDescriptorXMLUtils.getOrder(element);
        Element descriptionEl = element.element("description");
        if (descriptionEl == null || descriptionEl.attribute("key") == null) {
            throw new PluginParseException("<description> i18n 'key' attribute is a required attribute for a keyboard shortcut plugin module!");
        }
        this.descriptionKey = StringUtils.trim((String)descriptionEl.attributeValue("key"));
    }

    @Override
    protected KeyboardShortcut createModule() {
        return new KeyboardShortcut(this.context, this.operation, this.operationParam, this.order, this.shortcuts, this.descriptionKey, this.hidden);
    }

    @Override
    public void enabled() {
        super.enabled();
        this.keyboardShortcutManager.registerShortcut(this.getCompleteKey(), (KeyboardShortcut)this.getModule());
    }

    @Override
    public void disabled() {
        super.disabled();
        this.keyboardShortcutManager.unregisterShortcut(this.getCompleteKey());
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    private static List<String> parseShortcut(String shortcut) throws JSONException {
        if (JSON_VALUE_ARRAY.matcher(shortcut).matches()) {
            ArrayList<String> result = new ArrayList<String>();
            JSONArray array = new JSONArray(shortcut);
            for (int i = 0; i < array.length(); ++i) {
                result.add(array.getString(i));
            }
            return result;
        }
        if (JSON_VALUE_STRING.matcher(shortcut).matches()) {
            String key = "shortcut";
            JSONObject json = new JSONObject(String.format("{ \"%s\": %s }", "shortcut", shortcut));
            return Arrays.asList(json.getString("shortcut"));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (char c : shortcut.toCharArray()) {
            result.add(String.valueOf(c));
        }
        return result;
    }
}

