/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.watchers.WatchedIssuesAccessor;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.util.collect.CollectionUtil;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.Collections;
import java.util.List;

public class WatchedIssuesFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_WATCHED_ISSUES = "watchedIssues";
    private final WatchedIssuesAccessor watchAccessor;

    public WatchedIssuesFunction(WatchedIssuesAccessor watchAccessor) {
        this.watchAccessor = Assertions.notNull("watchAccessor", watchAccessor);
    }

    @Override
    public MessageSet validate(User searcher, FunctionOperand operand, TerminalClause terminalClause) {
        MessageSet messageSet;
        if (!this.watchAccessor.isWatchingEnabled()) {
            messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.watched.issues.disabled", this.getFunctionName()));
        } else if (searcher == null) {
            messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.anonymous.disallowed", this.getFunctionName()));
        } else {
            messageSet = this.validateNumberOfArgs(operand, 0);
        }
        return messageSet;
    }

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, final FunctionOperand operand, TerminalClause terminalClause) {
        Assertions.notNull("queryCreationContext", queryCreationContext);
        if (queryCreationContext.getQueryUser() == null) {
            return Collections.emptyList();
        }
        return CollectionUtil.toList(Transformed.iterable(this.getWatchedIssues(queryCreationContext.getQueryUser(), queryCreationContext.isSecurityOverriden()), new Function<Long, QueryLiteral>(){

            @Override
            public QueryLiteral get(Long votedIssue) {
                return new QueryLiteral((Operand)operand, votedIssue);
            }
        }));
    }

    @Override
    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    @Override
    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }

    Iterable<Long> getWatchedIssues(User searcher, boolean overrideSecurity) {
        WatchedIssuesAccessor.Security security = overrideSecurity ? WatchedIssuesAccessor.Security.OVERRIDE : WatchedIssuesAccessor.Security.RESPECT;
        return this.watchAccessor.getWatchedIssueIds(searcher, searcher, security);
    }
}

