/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractDateFunction;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;

public class StartOfYearFunction
extends AbstractDateFunction {
    public static final String FUNCTION_START_OF_YEAR = "startOfYear";

    StartOfYearFunction(Clock clock, TimeZoneManager timeZoneManager) {
        super(clock, timeZoneManager);
    }

    public StartOfYearFunction(TimeZoneManager timeZoneManager) {
        super(timeZoneManager);
    }

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        boolean hasAdjustment = operand.getArgs().size() == 1;
        int unit = 0;
        int incrementValue = 0;
        if (hasAdjustment) {
            String duration = operand.getArgs().get(0);
            unit = this.getDurationUnit(duration);
            if (unit == -1) {
                unit = 1;
            }
            incrementValue = this.getDurationAmount(duration);
        }
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(this.timeZoneManager.getLoggedInUserTimeZone());
        cal.setTime(this.clock.getCurrentDate());
        cal.getTime();
        if (hasAdjustment && unit == 1) {
            ((Calendar)cal).add(unit, incrementValue);
        }
        cal.set(2, ((Calendar)cal).getActualMinimum(2));
        cal.set(5, ((Calendar)cal).getActualMinimum(5));
        cal.set(11, ((Calendar)cal).getActualMinimum(11));
        cal.set(12, ((Calendar)cal).getActualMinimum(12));
        cal.set(13, ((Calendar)cal).getActualMinimum(13));
        cal.set(14, ((Calendar)cal).getActualMinimum(14));
        if (hasAdjustment && unit != 1) {
            ((Calendar)cal).add(unit, incrementValue);
        }
        return Collections.singletonList(new QueryLiteral((Operand)operand, cal.getTimeInMillis()));
    }
}

