/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractUserCapabilityFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProjectsWhereUserHasRoleFunction
extends AbstractUserCapabilityFunction {
    public static final String FUNCTION_PROJECTS_WHERE_USER_HAS_PERMISSION = "projectsWhereUserHasRole";
    private static final String JIRA_JQL_PROJECT_NO_SUCH_USER = "jira.jql.project.no.such.user";
    private final PermissionManager permissionManager;
    private final ProjectRoleManager projectRoleManager;
    private final ProjectManager projectManager;

    public ProjectsWhereUserHasRoleFunction(PermissionManager permissionManager, ProjectRoleManager projectRoleManager, ProjectManager projectManager, UserUtil userUtil) {
        super(userUtil);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.projectRoleManager = Assertions.notNull("roleManager", projectRoleManager);
        this.projectManager = Assertions.notNull("projectManager", projectManager);
    }

    @Override
    public JiraDataType getDataType() {
        return JiraDataTypes.PROJECT;
    }

    @Override
    protected MessageSet validateCapability(String roleName, I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (this.projectRoleManager.getProjectRole(roleName) == null) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.project.no.such.role", this.getFunctionName(), roleName));
        }
        return messageSet;
    }

    @Override
    protected List<QueryLiteral> getFunctionValuesList(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, User user, String roleName) {
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleName);
        if (projectRole == null) {
            return Collections.emptyList();
        }
        ArrayList<QueryLiteral> values = new ArrayList<QueryLiteral>();
        List<Project> allProjects = this.projectManager.getProjectObjects();
        for (Project project : allProjects) {
            if (!this.projectRoleManager.isUserInProjectRole(user, projectRole, project) || !queryCreationContext.isSecurityOverriden() && !this.permissionManager.hasPermission(10, project, queryCreationContext.getQueryUser())) continue;
            values.add(new QueryLiteral((Operand)functionOperand, project.getId()));
        }
        return values;
    }

    @Override
    protected String getUserNotFoundMessageKey() {
        return JIRA_JQL_PROJECT_NO_SUCH_USER;
    }
}

