/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.plugin.jql.function.AbstractUserCapabilityFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ProjectsWhereUserHasPermissionFunction
extends AbstractUserCapabilityFunction {
    public static final String FUNCTION_PROJECTS_WHERE_USER_HAS_PERMISSION = "projectsWhereUserHasPermission";
    private static final String JIRA_JQL_PROJECT_NO_SUCH_USER = "jira.jql.project.no.such.user";
    private final PermissionManager permissionManager;
    private final SchemePermissions schemePermissions;

    public ProjectsWhereUserHasPermissionFunction(PermissionManager permissionManager, SchemePermissions schemePermissions, UserUtil userUtil) {
        super(userUtil);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.schemePermissions = Assertions.notNull("schemePermissions", schemePermissions);
    }

    @Override
    public JiraDataType getDataType() {
        return JiraDataTypes.PROJECT;
    }

    @Override
    protected MessageSet validateCapability(String permissionName, I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (this.getPermissionByName(permissionName) == null) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.project.no.such.permission", this.getFunctionName(), permissionName));
        }
        return messageSet;
    }

    private Map.Entry<Integer, Permission> getPermissionByName(String name) {
        for (Map.Entry<Integer, Permission> permissionEntry : this.schemePermissions.getSchemePermissions().entrySet()) {
            if (!permissionEntry.getValue().getName().equalsIgnoreCase(name)) continue;
            return permissionEntry;
        }
        return null;
    }

    @Override
    protected List<QueryLiteral> getFunctionValuesList(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, User user, String permissionName) {
        Map.Entry<Integer, Permission> permissionEntry = this.getPermissionByName(permissionName);
        if (permissionEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<QueryLiteral> values = new ArrayList<QueryLiteral>();
        Collection<Project> projects = this.permissionManager.getProjectObjects(permissionEntry.getKey(), user);
        for (Project project : projects) {
            if (queryCreationContext.isSecurityOverriden() || !queryCreationContext.isSecurityOverriden() && !this.permissionManager.hasPermission(10, project, queryCreationContext.getQueryUser())) continue;
            values.add(new QueryLiteral((Operand)functionOperand, project.getId()));
        }
        return values;
    }

    @Override
    protected String getUserNotFoundMessageKey() {
        return JIRA_JQL_PROJECT_NO_SUCH_USER;
    }
}

