/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractUserBasedFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.List;

public class ProjectsLeadByUserFunction
extends AbstractUserBasedFunction {
    public static final String FUNCTION_PROJECTS_LEAD_BY_USER = "projectsLeadByUser";
    private static final String JIRA_JQL_PROJECT_NO_SUCH_USER = "jira.jql.project.no.such.user";
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;

    public ProjectsLeadByUserFunction(PermissionManager permissionManager, ProjectManager projectManager, UserUtil userUtil) {
        super(userUtil);
        this.permissionManager = permissionManager;
        this.projectManager = Assertions.notNull("projectManager", projectManager);
    }

    @Override
    public JiraDataType getDataType() {
        return JiraDataTypes.PROJECT;
    }

    @Override
    protected List<QueryLiteral> getFunctionValuesList(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, User user) {
        List<Project> projects = this.projectManager.getProjectsLeadBy(user);
        ArrayList<QueryLiteral> values = new ArrayList<QueryLiteral>();
        for (Project project : projects) {
            if (!queryCreationContext.isSecurityOverriden() && !this.permissionManager.hasPermission(10, project, queryCreationContext.getQueryUser())) continue;
            values.add(new QueryLiteral((Operand)functionOperand, project.getId()));
        }
        return values;
    }

    @Override
    protected String getUserNotFoundMessageKey() {
        return JIRA_JQL_PROJECT_NO_SUCH_USER;
    }
}

