/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.resolver.ProjectResolver;
import com.atlassian.jira.plugin.jql.function.AbstractSingleVersionFunction;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class LatestReleasedVersionFunction
extends AbstractSingleVersionFunction {
    public static final String FUNCTION_LATEST_RELEASED_VERSION = "latestReleasedVersion";
    private final VersionManager versionManager;

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        return super.getValues(queryCreationContext, operand, terminalClause);
    }

    public LatestReleasedVersionFunction(VersionManager versionManager, ProjectResolver projectResolver, PermissionManager permissionManager) {
        super(projectResolver, permissionManager);
        this.versionManager = Assertions.notNull("versionManager", versionManager);
    }

    @Override
    protected Version getVersionForProject(Long projectId) {
        Collection<Version> allVersions = this.versionManager.getVersionsReleased(projectId, true);
        if (allVersions != null && allVersions.size() > 0) {
            TreeSet<Version> sortedVersions = new TreeSet<Version>(new Comparator<Version>(){

                @Override
                public int compare(Version version, Version version1) {
                    return version.getSequence().compareTo(version1.getSequence());
                }
            });
            sortedVersions.addAll(allVersions);
            return sortedVersions.last();
        }
        return null;
    }
}

